<?php

$global_schedule = get_site_option( 'bb_single_schedule' );

$users         = get_users( array( 'fields' => array( 'ID', 'display_name' ) ) );
$staff_members = [];

foreach ( $users as $user ) {
	$user_meta = get_userdata( $user->ID );

	if ( ! in_array( 'mbbb_staff_member', $user_meta->roles ) && ! in_array( 'administrator', $user_meta->roles ) ) {
		continue;
	}

	$staff_members[] = array(
		'ID' => $user->ID,
		'display_name' => $user->display_name
	);
}

$current_user       = wp_get_current_user();
$current_user_roles = $current_user->roles;

if ( in_array( 'mbbb_staff_member', $current_user_roles ) ) {
	foreach ( $staff_members as $key => $member ) {
		if ( $current_user->ID === intval( $member['ID'] ) ) {
			continue;
		}

		unset( $staff_members[$key] );
	}
}

if ( in_array( 'mbbb_staff_member', $current_user_roles ) ) {
	include BB_PLUGIN_DIR . '/admin/templates/schedule/staff-member.php';
} else {
	include BB_PLUGIN_DIR . '/admin/templates/schedule/admin.php';
}