<?php

$notifications_shortcodes = [
	'[date]' => __( 'Adds the date of the appointment to the message', 'brindle-booking' ),
	'[time]' => __( 'Adds the time of the appointment to the message', 'brindle-booking' ),
	'[staff member]' => __( 'Adds the Staff Member (if applicable) selected during appointment to the message', 'brindle-booking' ),
	'[category]' => __( 'Adds the Category of the appointment to the message', 'brindle-booking' ),
	'[service]' => __( 'Adds the Service of the appointment to the message', 'brindle-booking' ),
	'[name]' => __( 'Adds name of visitor who booked appointment', 'brindle-booking' ),
	'[email]' => __( 'Adds email of visitor who booked appointment', 'brindle-booking' ),
	'[phone]' => __( 'Adds phone number of visitor who booked appointment', 'brindle-booking' ),
	'[address]' => __( 'Adds address of visitor who booked appointment', 'brindle-booking' ),
	'[site link]' => __( 'Adds your site title/link to the message', 'brindle-booking' ),
	'[zoom link]' => __( 'Adds a link to the zoom meeting (if applicable).', 'brindle-booking' ),
	'[details]' => __( 'Adds a table with the details of the appointment (add only as a new/separate paragraph to avoid styling issues)', 'brindle-booking' ),
];

?>

<section class="bb-section bb-section--sm-head">
	<div class="section__logo">
		<img src="<?php echo BB_PLUGIN_URL . 'images/booking-logo.png' ?>"/>
	</div><!-- /.section__logo -->

	<div class="section__inner">
		<div class="section__content">
			<?php include_once( BB_PLUGIN_DIR . 'admin/templates/bar.php' ); ?>

			<div class="section__content-inner">
				<form class="mb-bb-admin-form bb-form-notifications bb-form" method="post" action="<?php echo admin_url( 'admin-post.php' ) ?>" enctype="multipart/form-data">
					<input type="hidden" name="action" value="bb_notifications_options_form">
					<input type="hidden" name="mb_bb_notifications_form_nonce" value="<?php echo wp_create_nonce( 'mb_bb_settings_options_nonce' ); ?>" />

					<?php foreach ( $fields as $title => $fields ) : ?>
						<div class="form__section">
							<?php if ( ! empty( $title ) ) : ?>
								<header class="section__head section__head--sm">
									<p><?php echo $title; ?></p>
								</header><!-- /.section__head -->
							<?php endif; ?>

							<?php foreach ( $fields as $key => $field ) : ?>
								<div class="section__row">
									<div class="form__controls">
										<?php include BB_PLUGIN_DIR . 'admin/templates/fields/' . str_replace( '_', '-', $field['type'] ) . '.php' ?>
									</div><!-- /.form__controls -->
								</div><!-- /.section__row -->
							<?php endforeach ?>
						</div><!-- /.form__section -->
					<?php endforeach ?>
				</form>

				<?php if ( ! empty( $notifications_shortcodes ) ) : ?>
					<div class="section__foot">
						<div class="section__foot-head">
							<p><strong><?php echo __( 'Guide to labels:', 'brindle-booking' ); ?></strong></p>
						</div><!-- /.section__foot-head -->

						<div class="section__foot-body">
							<?php foreach ( $notifications_shortcodes as $shortcode => $description ) : ?>
								<p><?php echo sprintf( '<strong>%s</strong> %s', $shortcode, $description ); ?></p>
							<?php endforeach; ?>
						</div><!-- /.section__foot-body -->
					</div><!-- /.section__foot -->
				<?php endif; ?>
			</div><!-- /.section__content-inner -->
		</div><!-- /.section__content -->

		<div class="section__sidebar">
			<a class="bb-btn js-bb-save" href="#"><?php _e( 'Save Changes', 'brindle-booking' ) ?></a>
		</div><!-- /.section__sidebar -->
	</div><!-- /.section__inner -->
</section><!-- /.bb-section -->