<section class="bb-section">
	<div class="section__logo">
		<img src="<?php echo BB_PLUGIN_URL . 'images/booking-logo.png' ?>"/>
	</div><!-- /.section__logo -->

	<div class="section__inner">
		<div class="section__content">
			<?php include_once( BB_PLUGIN_DIR . 'admin/templates/bar.php' ); ?>

			<div class="section__content-inner">
				<header class="section__head">
					<p><?php _e( 'Documentation and Support', 'brindle-booking' ) ?></p>
				</header><!-- /.section__head -->

				<div class="section__body">
					<p><?php echo __( 'Find Our <a href="https://mybrindle.com/brindle-booking-documentation/" target="blank">In Depth Documentation Here</a>', 'brindle-booking' ); ?></p>
				</div><!-- /.section__body -->
				<div class="section__body">
					<p><?php echo __( 'Need Support? <a href="https://mybrindle.com/brindle-tech-support/" target="blank">Submit a Support Ticket Here</a>', 'brindle-booking' ); ?></p>
				</div><!-- /.section__body -->

				<header class="section__head">
					<p><?php _e( 'Shortcodes', 'brindle-booking' ) ?></p>
				</header><!-- /.section__head -->

				<div class="section__body">
					<p>1. <code>[bb-popup-trigger]</code> - <?php echo __( 'This shortcode renders a link that triggers the booking popup on click. This shortcode can be altered to control the label and styling. See below for details.', 'brindle-booking' ); ?></p>

					<p><?php echo __( 'Possible attributes for this shortcode are:' ) ?></p>

					<ul>
						<li><code>content</code> - <?php echo __( 'defines the text content inside the button, defaults to "Book Our Service"', 'brindle-booking' ) ?></li>

						<li><code>id</code> - <?php echo __( 'adds an ID attribute to the button element', 'brindle-booking' ) ?></li>

						<li><code>class</code> - <?php echo __( 'adds a class attribute to the button element', 'brindle-booking' ) ?></li>
					</ul>

					<p><?php echo __( 'An example using all of the possible attributes:' ); ?><br><code>[bb-popup-trigger id="example-id" class="example-class-name" content="Make An Appointment"]</code></p>
				</div><!-- /.section__body -->

				<div class="section__body">
					<p>2. Page Embed Shortcode: <code>[bb-booking-module]</code> - <?php echo __( 'This shortcode embeds the booking module inside the page content.', 'brindle-booking' ); ?></p>
				</div><!-- /.section__body -->

				<header class="section__head">
					<p><?php _e( 'CSS Class', 'brindle-booking' ) ?></p>
				</header><!-- /.section__head -->

				<div class="section__body">
					<p><code>bb-js-trigger-popup</code> - <?php echo __( 'adding this class to an existing element will turn the element into a trigger (on click) to open the booking interface. Perfect for adding the functionality to existing buttons/links, and for use in page builders (Divi, Elementor, etc.).', 'brindle-booking' ); ?></p>
				</div><!-- /.section__body -->
			</div><!-- /.section__content-inner -->
		</div><!-- /.section__content -->
	</div><!-- /.section__inner -->
</section><!-- /.bb-section -->