<?php

$access_token = mbbb_check_access_token();

$label = __( 'Connect Zoom Account', 'brindle-booking' );
$url   = sprintf( 'https://mybrindle.com/zoom-authorize.php?state=%s&home_url=%s&endpoint=%s', 'https://mybrindle.com/zoom-authorize.php', $_SERVER['SERVER_NAME'], admin_url( 'admin.php?page=brindle-booking-integrations' ) );

$user_key = get_site_option( 'bb_zoom_api_user_key', '' );

if ( ! empty( $access_token ) ) {
	if ( ! wp_next_scheduled( 'mbbb_refresh_access_token_55_min' ) ) {
		wp_schedule_event( time(), '55min', 'mbbb_refresh_access_token_55_min' );
	}

	$label = __( 'Disconnect Zoom Account', 'brindle-booking' );
	$url   = sprintf( 'https://mybrindle.com/zoom-disconnect.php?domain=%s&endpoint=%s&user_key=%s', $_SERVER['SERVER_NAME'], admin_url( 'admin.php?page=brindle-booking-integrations' ), $user_key );
} else {
	if ( wp_next_scheduled( 'mbbb_refresh_access_token_55_min' ) ) {
		$timestamp = wp_next_scheduled( 'mbbb_refresh_access_token_55_min' );

		wp_unschedule_event( $timestamp, 'mbbb_refresh_access_token_55_min' );
	}
}

?>

<div class="field-zoom">
	<a
	href="<?php echo $url; ?>"
	class="bb-btn bb-btn--alt">
		<?php echo $label; ?>
	</a>
</div><!-- /.field-zoom -->
