<?php if ( ! empty( $field['title'] ) || ! empty( $field['hint'] ) ) : ?>
	<label for="<?php echo $key; ?>">
		<?php if ( ! empty( $field['title'] ) ) : ?>
				<?php echo ! empty( $field['title'] ) ? $field['title'] : ''; ?>
			<?php endif; ?>

		<?php if ( ! empty( $field['hint'] ) ) : ?>
			<span class="field-tooltip-container">
				<span class="field-tooltip-icon"><span>?</span></span>

				<span class="field-tooltip" style="display: none;">
					<?php esc_html_e( $field['hint'] ); ?>
				</span>
			</span>
		<?php endif ?>
	</label>
<?php endif; ?>

<input type="<?php esc_attr_e( $field['type'] ); ?>" id="<?php echo $key; ?>" name="<?php echo $key; ?>" value="<?php echo ! empty( $field['value'] ) ? esc_attr( $field['value'] ) : ''; ?>" placeholder="<?php esc_attr_e( $field['placeholder'] ); ?>" <?php echo ! empty( $field['accept'] ) ? 'accept="' . $field['accept'] . '"' : ''; ?> <?php echo ! empty( $field['class'] ) ? 'class="' . $field['class'] . '"' : ''; ?>>

<?php if ( ! empty( $field['help_text'] ) ) : ?>
	<?php echo apply_filters( 'the_content', $field['help_text'] ); ?>
<?php endif ?>