<?php

if ( empty( $field['options'] ) ) {
	return;
}

?>

<?php if ( ! empty( $field['title'] ) || ! empty( $field['hint'] ) ) : ?>
	<label for="<?php echo $key; ?>">
		<?php if ( ! empty( $field['title'] ) ) : ?>
			<?php echo ! empty( $field['title'] ) ? $field['title'] : ''; ?>
		<?php endif; ?>

		<?php if ( ! empty( $field['hint'] ) ) : ?>
			<span class="field-tooltip-container">
				<span class="field-tooltip-icon"><span>?</span></span>

				<span class="field-tooltip" style="display: none;">
					<?php esc_html_e( $field['hint'] ); ?>
				</span>
			</span>
		<?php endif ?>
	</label>
<?php endif; ?>

<div class="select">
	<select
	name="<?php echo $key; ?>"
	id="<?php echo $key; ?>"
	<?php echo ! empty( $field['class'] ) ? 'class="' . $field['class'] . '"' : ''; ?>
	>
		<?php if ( ! empty( $placeholder ) ) : ?>
			<option value="0">
				<?php echo esc_html( $field['placeholder'] ); ?>
			</option>
		<?php endif; ?>

		<?php foreach ( $field['options'] as $key => $option ) :

		$selected_currency = get_site_option( 'bb_payment_currency' );

		?>
			<option
			value="<?php echo esc_html( $key ); ?>"
			<?php echo $selected_currency === $key ? 'selected' : ''; ?>
			>
				<?php echo esc_html( $option ); ?>
			</option>
		<?php endforeach; ?>
	</select>
</div><!-- /.select -->

<?php if ( ! empty( $field['help_text'] ) ) : ?>
	<?php echo apply_filters( 'the_content', $field['help_text'] ); ?>
<?php endif ?>