<?php


if ( empty( $key ) || empty( $field['checkboxes'] ) ) {
	return;
}

?>

<div class="form__radio" id="<?php echo esc_attr( $key ); ?>">
	<ul>
		<?php foreach ( $field['checkboxes'] as $checkbox ) : ?>
			<li>
				<div class="form__checkbox">
					<input
					type="radio"
					id="<?php echo $checkbox['id']; ?>"
					name="<?php echo $key; ?>"
					value="<?php echo strval( $checkbox['value'] ) ?>"
					<?php echo strval( $checkbox['value'] ) === strval( $field['value'] ) ? 'checked' : ''; ?>>

					<label for="<?php echo $checkbox['id']; ?>">
						<?php echo $checkbox['label']; ?>

						<?php if ( ! empty( $checkbox['hint'] ) ) : ?>
							<span class="field-tooltip-container">
								<span class="field-tooltip-icon"><span>?</span></span>

								<span class="field-tooltip" style="display: none;">
									<?php esc_html_e( $checkbox['hint'] ); ?>
								</span>
							</span>
						<?php endif ?>
					</label>
				</div><!-- /.form__checkbox -->
			</li>
		<?php endforeach; ?>
	</ul>
</div><!-- /.form__radio -->
