<?php

$access_token = mbbb_google_check_access_token();

$label = __( 'Connect Google Account', 'brindle-booking' );
$url   = sprintf( 'https://mybrindle.com/google-calendar/google-connect.php?url=%s&user-id=%s&endpoint=%s', $_SERVER['SERVER_NAME'], strval( get_current_user_id() ), urlencode( admin_url( 'admin.php?page=brindle-booking-integrations' ) ) );

$user_key = get_site_option( 'bb_google_api_user_key_' . strval( get_current_user_id() ), '' );

if ( ! empty( $access_token ) ) {
	if ( ! wp_next_scheduled( 'mbbb_google_api_refresh_access_token_55_min_' . strval( get_current_user_id() ) ) ) {
		wp_schedule_event( time(), '55min', 'mbbb_google_api_refresh_access_token_55_min_' . strval( get_current_user_id() ) );
	}

	$label = __( 'Disconnect Google Account', 'brindle-booking' );
	$url   = sprintf( 'https://mybrindle.com/google-calendar/google-disconnect.php?url=%s&user-id=%s&endpoint=%s&user-key=%s', $_SERVER['SERVER_NAME'], strval( get_current_user_id() ), urlencode( admin_url( 'admin.php?page=brindle-booking-integrations' ) ), $user_key );
} else {
	if ( wp_next_scheduled( 'mbbb_google_api_refresh_access_token_55_min_' . strval( get_current_user_id() ) ) ) {
		$timestamp = wp_next_scheduled( 'mbbb_google_api_refresh_access_token_55_min_' . strval( get_current_user_id() ) );

		wp_unschedule_event( $timestamp, 'mbbb_google_api_refresh_access_token_55_min_' . strval( get_current_user_id() ) );
	}
}

?>

<div class="field-zoom">
	<a
	href="<?php echo $url; ?>"
	class="bb-btn bb-btn--alt">
		<?php echo $label; ?>
	</a>
</div><!-- /.field-zoom -->
