<?php

if ( empty( $field ) ) {
	return;
}

$post_types = [];
$admins_type = false;

foreach ( $field['types'] as $type ) {
	if ( $type['post_type'] === 'administrators' ) {
		$admins_type = true;
		
		continue;
	}

	if ( $type['post_type'] !== 'custom_post_type' ) {
		$post_types[] = $type;
	}

	if ( $type['post_type'] === 'custom_post_type' ) {
		$all_site_post_types = get_post_types( [ 'public' => true ], 'names', 'and' );

		unset( $all_site_post_types['attachment'] );

		$post_types = $all_site_post_types;
	}
}

$posts = [];

if ( ! empty( $post_types ) ) {
	$args = [
		'post_type'   => $post_types,
		'post_status' => 'publish'
	];

	$query = new WP_Query( $args );

	$posts = $query->posts;
} else if ( empty( $post_types ) && $admins_type ) {
	$admins = get_users( [
		'role__in' => 'administrator'
	] );

	$posts = $admins;
}

if ( empty( $posts ) ) {
	return;
}

$selected_posts = explode( '|', $field['value'] );
$notified_admins = get_option( 'bb_notified_admins' );

?>

<div class="bb-association">
	<input type="hidden" id="<?php echo 'bb_association_data_' . $key; ?>" name="<?php echo 'bb_association_data_' . $key ?>" value="<?php echo $field['value'] ?>">

	<?php if ( ! empty( $field['title'] ) ) : ?>
		<h4><?php echo esc_html( $field['title'] ); ?></h4>
	<?php endif; ?>

	<div class="association__body">
		<div class="association__side association__side--left">
			<ul>
				<?php foreach ( $posts as $post ) :

				if ( ! $admins_type ) {
					$title = get_the_title( $post );
				} else {
					$title = $post->display_name;
				}


				?>
					<li class="<?php echo in_array( strval( $post->ID ), $selected_posts ) ? 'disabled' : ''; ?>">
						<a href="#" class="js-association" data-post-id="<?php echo $post->ID ?>">
							<i class="bb-ico-plus"></i>

							<span><?php echo $title; ?></span>
						</a>
					</li>
				<?php endforeach; ?>
			</ul>
		</div><!-- /.association__side -->

		<div class="association__side association__side--right">
			<ul>
				<?php if ( ! empty( $field['value'] ) ) : ?>
					<?php foreach ( $selected_posts as $selected_post ) :

					if ( ! $admins_type ) {
						$title = get_the_title( $selected_post );
					} else {
						$userdata = get_userdata( intval( $selected_post ) );
						$title = $userdata->display_name;
					}


					?>
						<li>
							<a href="#" class="js-association" data-post-id="<?php echo $selected_post ?>">
								<i class="bb-ico-plus bb-ico-plus--minus"></i>

								<span><?php echo $title; ?></span>
							</a>
						</li>
					<?php endforeach; ?>
				<?php endif; ?>
			</ul>
		</div><!-- /.association__side -->
	</div><!-- /.association__body -->

	<?php if ( ! empty( $field['help_text'] ) ) : ?>
		<div class="association__foot">
			<p>
				<?php echo $field['help_text']; ?>
			</p>
		</div><!-- /.association__foot -->
	<?php endif; ?>
</div><!-- /.bb-association -->