<?php
$screen   = get_current_screen();

$subpages = [
	//'brindle-booking-calendar' => __( 'Calendar', 'brindle-booking' ),
	'brindle-booking'               => __( 'Services', 'brindle-booking' ),
	'brindle-booking-design'        => __( 'Design', 'brindle-booking' ),
	'brindle-booking-settings'      => __( 'Settings', 'brindle-booking' ),
	'brindle-booking-schedule'      => __( 'Schedule', 'brindle-booking' ),
	'brindle-booking-notifications' => __( 'Notifications', 'brindle-booking' ),
	'brindle-booking-integrations'  => __( 'Integrations', 'brindle-booking' ),
	'brindle-booking-help'          => __( 'Help', 'brindle-booking' ),
];

$user = wp_get_current_user();

if ( in_array( 'mbbb_staff_member', $user->roles ) ) {
	$subpages = [
		'brindle-booking' => __( 'Schedule', 'brindle-booking' ),
		'brindle-booking-integrations'  => __( 'Integrations', 'brindle-booking' ),
	];
}
?>
<div class="section__bar">
	<ul>
		<?php foreach ( $subpages as $key => $name ) : ?>
			<li <?php echo in_array( $screen->id, [ "my-brindle_page_{$key}", "admin_page_{$key}" ] ) ? 'class="current"' : '';  ?>>
				<a href="<?php menu_page_url( $key ); ?>"><?php echo $name; ?></a>
			</li>
		<?php endforeach ?>
	</ul>
</div><!-- /.section__bar -->