<?php

$generate_zoom = get_post_meta( intval( $id ), 'bb_generate_zoom_meeting', true );

if ( $generate_zoom === '' ) {
	$generate_zoom = 0;
}

$generate_google_calender = get_post_meta( intval( $id ), 'bb_generate_google_calendar_reminder', true );

if ( $generate_google_calender === '' ) {
	$generate_google_calender = 0;
}

?>

<div class="content">
	<h2><?php _e( 'Edit Service', 'brindle-booking' ); ?></h2>

	<form class="bb-form-service js-form-edit-service" method="post" action="<?php echo admin_url( 'admin-post.php' ) ?>">
		<input type="hidden" name="action" value="bb_process_edit_form">
		<input type="hidden" name="mb_bb_edit_service_nonce" value="<?php echo wp_create_nonce( 'mb_bb_edit_service_form_nonce' ); ?>">
		<input type="hidden" name="mb_bb_id" value="<?php echo $id; ?>">
		<input type="hidden" name="mb_bb_cat" value="<?php echo $cat; ?>">
		<input type="hidden" name="mb_bb_paged" value="<?php echo $paged; ?>">

		<div class="form__controls">
			<label for="service_title"><?php _e( 'Service Title', 'brindle-booking' ); ?></label>

			<input type="text" name="service_title" id="service_title" required="" value="<?php echo get_the_title( $id ); ?>">
		</div><!-- /.form__controls -->

		<div class="form__controls">
			<label for="service_title"><?php _e( 'Category ', 'brindle-booking' ); ?><span><?php _e( '(optional)' ) ?></span></label>

			<div class="select">
				<select name="service_category" id="service_category">
					<option value=""><?php _e( 'Please select a service category...', 'brindle-booking' ); ?></option>

					<?php if ( ! empty( $categories ) ) : ?>
						<?php foreach ( $categories as $category ) : ?>
							<option value="<?php esc_attr_e( $category->term_id ); ?>" <?php echo in_array( $category->term_id, $terms_ids ) ? 'selected' : ''; ?>><?php esc_html_e( $category->name ); ?></option>
						<?php endforeach ?>
					<?php endif ?>
				</select>
			</div><!-- /.select -->
		</div><!-- /.form__controls -->

		<div class="form__controls">
			<label for="price"><?php _e( 'Price ', 'brindle-booking' ); ?><span><?php _e( '(optional)' ) ?></span></label>

			<input type="text" name="service_price" id="service_price" value="<?php echo ! empty( $price ) ? esc_attr( $price ) : ''; ?>">
		</div><!-- /.form__controls -->

		<div class="form__notice">
			<?php _e( '*Be sure to include all fees/taxes if allowing online payment as this is the full price that will be charged to the customer.', 'brindle-booking' ); ?>
		</div><!-- /.form__notice -->

		<div class="form__controls">
			<div class="form__checkbox">
				<input
				type="checkbox"
				name="generate_zoom_meeting"
				id="generate_zoom_meeting"
				value="1"
				<?php echo ! empty( $generate_zoom ) ? 'checked' : ''; ?>>
				
				<label for="generate_zoom_meeting">
					<?php _e( 'Generate Zoom link when service is booked', 'brindle-booking' ); ?>
				</label>
			</div><!-- /.form__checkbox -->
		</div><!-- /.form__controls -->

		<div class="form__controls">
			<div class="form__checkbox">
				<input
				type="checkbox"
				name="generate_google_calendar_reminder"
				id="generate_google_calendar_reminder"
				value="1"
				<?php echo ! empty( $generate_google_calender ) ? 'checked' : ''; ?>>
				
				<label for="generate_google_calendar_reminder">
					<?php _e( 'Generate Google Calendar reminder when service is booked', 'brindle-booking' ); ?>
				</label>
			</div><!-- /.form__checkbox -->
		</div><!-- /.form__controls -->

		<div class="form__foot">
			<a href="#" class="js-close-popup"><?php _e( 'Cancel', 'brindle-booking' ); ?></a>

			<input class="btn" type="submit" name="submit" value="<?php _e( 'Update Service', 'brindle-booking' ); ?>">
		</div><!-- /.form__foot -->
	</form>
</div><!-- /.content -->