<div class="content">
	<h2><?php _e( 'Add New Service', 'brindle-booking' ); ?></h2>

	<form class="bb-form-service js-form-add-service" method="post" action="<?php echo admin_url( 'admin-post.php' ) ?>">
		<input type="hidden" name="action" value="bb_process_form">
		<input type="hidden" name="mb_bb_add_service_nonce" value="<?php echo wp_create_nonce( 'mb_bb_add_service_form_nonce' ); ?>" />

		<div class="form__controls">
			<label for="service_title"><?php _e( 'Service Title', 'brindle-booking' ); ?></label>

			<input type="text" name="service_title" id="service_title" required>
		</div><!-- /.form__controls -->

		<div class="form__controls">
			<label for="service_title"><?php _e( 'Category ', 'brindle-booking' ); ?><span><?php _e( '(optional)', 'brindle-booking' ) ?></span></label>

			<div class="select">
				<select name="service_category" id="service_category">
					<option value=""><?php _e( 'Please select a service category...', 'brindle-booking' ); ?></option>

					<?php if ( ! empty( $categories ) ) : ?>
						<?php foreach ( $categories as $category ) : ?>
							<option value="<?php esc_attr_e( $category->term_id ); ?>"><?php esc_html_e( $category->name ); ?></option>
						<?php endforeach ?>
					<?php endif ?>
				</select>
			</div><!-- /.select -->
		</div><!-- /.form__controls -->

		<div class="form__controls">
			<label for="price"><?php _e( 'Price ', 'brindle-booking' ); ?><span><?php _e( '(optional)', 'brindle-booking' ) ?></span></label>

			<input type="text" name="service_price" id="service_price">
		</div><!-- /.form__controls -->

		<div class="form__notice">
			<?php _e( '*Be sure to include all fees/taxes if allowing online payment as this is the full price that will be charged to the customer.', 'brindle-booking' ); ?>
		</div><!-- /.form__notice -->

		<div class="form__controls">
			<div class="form__checkbox">
				<input type="checkbox" name="generate_zoom_meeting" id="generate_zoom_meeting" value="">
				
				<label for="generate_zoom_meeting">
					<?php _e( 'Generate Zoom link when service is booked', 'brindle-booking' ); ?>
				</label>
			</div><!-- /.form__checkbox -->
		</div><!-- /.form__controls -->

		<div class="form__controls">
			<div class="form__checkbox">
				<input type="checkbox" name="generate_google_calendar_reminder" id="generate_google_calendar_reminder" value="">
				
				<label for="generate_google_calendar_reminder">
					<?php _e( 'Generate Google Calendar reminder when service is booked', 'brindle-booking' ); ?>
				</label>
			</div><!-- /.form__checkbox -->
		</div><!-- /.form__controls -->

		<div class="form__foot">
			<a href="#" class="js-close-popup"><?php _e( 'Cancel', 'brindle-booking' ); ?></a>

			<input type="submit" name="submit" value="<?php _e( 'Add Service', 'brindle-booking' ); ?>">
		</div><!-- /.form__foot -->
	</form>
</div><!-- /.content -->