<?php

$fields = [
		sprintf( '%s <span>| %s</span>', __( 'Admins:', 'brindle-booking' ), __( 'The admin that will be receiving notifications', 'brindle-booking' ) ) => [
			'notified_admins' => [
				'title' => '',
				'type'  => 'association',
				'value' => get_site_option( 'bb_notified_admins', '' ),
				'types' => [
					[
						'post_type' => 'administrators'
					],
				],
				'help_text' => sprintf( '%s <a href="%s">%s</a>.', __( 'If left empty, the email will be sent to "Administration Email Address" in the', 'brindle-booking' ), admin_url( 'options-general.php' ), __( 'general settings', 'brindle-booking' ) )
			],
			'no_notification_admin' => [
				'title' => __( 'Don\'t send notification to any admins.', 'brindle-booking' ),
				'type'  => 'checkbox',
				'value' => get_site_option( 'bb_no_notification_admin', '' ),
			]
		],
		sprintf( '%s <span>| %s</span>', __( 'Notification Name From:', 'brindle-booking' ), __( 'The name that will appear as the email sender', 'brindle-booking' ) ) => [
			'mail_name_from' => [
				'title'   => '',
				'type'    => 'text',
				'value'   => get_site_option( 'bb_mail_name_from', 'WordPress' ),
				'placeholder' => ''
			],
		],
		sprintf( '%s <span>| %s</span>', __( 'Admin/Staff Notification', 'brindle-booking' ), __( 'The message sent to site admin and staff members when an appointment is booked', 'brindle-booking' ) ) => [
			'admin_notification' => [
				'title'   => '',
				'type'    => 'rich_text',
				'value'   => stripslashes( get_site_option( 'bb_admin_notification', 'Hello! A visitor has booked an appointment on [date] at [time] with [staff member] for [category] [service].' ) ),
				'options' => [
						'media_buttons' => false,
						'tinymce'       => [
							'toolbar1'    => 'formatselect,bold,italic,link',
							'toolbar2'    => false,
							'statusbar'   => false,
							'content_css' => BB_PLUGIN_URL . 'css/tinymce.css',
							'height'      => 100
						],
						'quicktags' => false,
					]
			],
			'admin_notification_subject' => [
				'title'   => sprintf( '%s <span>| %s</span>', __( 'Message Topic', 'brindle-booking' ), __( 'The topic that appears in the email’s subject line (admin & staff members)', 'brindle-booking' ) ),
				'type'    => 'text',
				'value'   => get_site_option( 'bb_admin_notification_subject', 'Booking Reservation' ),
				'placeholder' => ''
			],
		],
		sprintf( '%s <span>| %s</span>', __( 'Visitor Notification', 'brindle-booking' ), __( 'The message sent to individuals who have booked an appointment', 'brindle-booking' ) ) => [
			'visitor_notification' => [
				'title' => '',
				'type'  => 'rich_text',
				'value' => stripslashes( get_site_option( 'bb_visitor_notification', 'Thank you for making a reservation with [site link]. <br> You have booked an appointment on [date] at [time] with [staff member] for [category] [service]. You can review the booking details here: <br><br> [details]' ) ),
				'options' => [
						'media_buttons' => false,
						'tinymce'       => [
							'toolbar1'    => 'formatselect,bold,italic,link',
							'toolbar2'    => false,
							'statusbar'   => false,
							'content_css' => BB_PLUGIN_URL . 'css/tinymce.css',
							'height'      => 100
						],
						'quicktags' => false,
					]
			],
			'visitor_notification_subject' => [
				'title'   => sprintf( '%s <span>| %s</span>', __( 'Message Topic', 'brindle-booking' ), __( 'The topic that appears in the email’s subject line (visitor)', 'brindle-booking' ) ),
				'type'    => 'text',
				'value'   => get_site_option( 'bb_visitor_notification_subject', 'Your Booking is Confirmed!' ),
				'placeholder' => ''
			],
		],
];