<?php
/**
 * Creates the submenu page for the plugin.
 */

/**
 * Creates the submenu page for the plugin.
 *
 * Provides the functionality necessary for rendering the page corresponding
 * to the submenu with which this page is associated.
 */
class Brindle_Booking_Page {

	/**
	 * This function renders the contents of the page associated with the Brindle_Booking
	 * that invokes the render method. In the context of this plugin, this is the
	 * Brindle_Booking class.
	 */
	public function render_services_page() {
		$category_query_args = [
			'taxonomy'   => 'bb_service_category',
			'hide_empty' => false,
		];

		$categories = get_terms( $category_query_args );
		$categories = mbbb_order_service_categories( $categories );

		$paged = isset( $_GET['paged'] ) ? absint( $_GET['paged'] ) : 1;

		$args = [
			'post_type'      => 'bb_service',
			'paged'          => $paged,
			'posts_per_page' => -1,
		];

		$services_order = mbbb_get_services_page_order();

		if ( ! empty( $_GET['category-filter'] ) ) {
			$args['tax_query'] = [
				[
					'taxonomy' => 'bb_service_category',
					'field'    => 'term_id',
					'terms'    => [ absint( $_GET['category-filter'] ) ]
				]
			];
		}

		$query = new WP_Query( $args );

		$posts = $query->posts;
		$posts = mbbb_order_services( $posts, $services_order );

		include_once( BB_PLUGIN_DIR . 'admin/templates/services.php' );
	}

	public function render_design_page() {
		$main_color   = get_site_option( 'bb_main_color', true );
		$accent_color = get_site_option( 'bb_accent_color', true );
		$titles_color = get_site_option( 'bb_titles_color', true );

		include_once( BB_PLUGIN_DIR . 'admin/templates/design.php' );
	}

	public function render_settings_page() {
		include_once( BB_PLUGIN_DIR . 'admin/fields/settings.php' );

		include_once( BB_PLUGIN_DIR . 'admin/templates/settings.php' );
	}

	public function render_integrations_page() {
		$access_code = isset( $_GET['user-key'] ) ? strip_tags( $_GET['user-key'] ) : false;
		$disconnect_zoom = isset( $_GET['disconnect-zoom'] ) ? strip_tags( $_GET['disconnect-zoom'] ) : false;

		if ( $access_code !== false ) {
			update_site_option( 'bb_zoom_api_user_key', esc_sql( $access_code ) );
		}

		if ( ! empty( $disconnect_zoom ) ) {
			update_site_option( 'bb_zoom_api_user_key', '' );
		}

		$google_access_code = isset( $_GET['google-access-code'] ) ? strip_tags( $_GET['google-access-code'] ) : false;
		$disconnect_google = isset( $_GET['disconnect-google'] ) ? strip_tags( $_GET['disconnect-google'] ) : false;

		if ( $google_access_code !== false ) {
			update_site_option( 'bb_google_api_user_key_' . strval( get_current_user_id() ), esc_sql( $google_access_code ) );
		}

		if ( ! empty( $disconnect_google ) ) {
			update_site_option( 'bb_google_api_user_key_' . strval( get_current_user_id() ), '' );
		}

		include_once( BB_PLUGIN_DIR . 'admin/fields/integrations.php' );

		include_once( BB_PLUGIN_DIR . 'admin/templates/integrations.php' );
	}

	public function render_schedule_page() {
		if ( isset( $_GET['single_schedule'] ) ) {
			if ( ! empty( $_GET['single_schedule'] ) ) {
				update_site_option( 'bb_single_schedule', 1 );
			} else {
				update_site_option( 'bb_single_schedule', 0 );
			}
		}

		if ( isset( $_GET['schedule_hour_standard'] ) ) {
			if ( $_GET['schedule_hour_standard'] === '12_hour_standard' ) {
				update_site_option( 'bb_schedule_12_hour_standard', 1 );
				update_site_option( 'bb_schedule_24_hour_standard', 0 );
			} else if ( $_GET['schedule_hour_standard'] === '24_hour_standard' ) {
				update_site_option( 'bb_schedule_12_hour_standard', 0 );
				update_site_option( 'bb_schedule_24_hour_standard', 1 );
			}
		}

		$global_schedule = get_site_option( 'bb_single_schedule' );

		if ( empty( $global_schedule ) ) {
			if ( isset( $_GET['user_id'] ) && is_numeric( $_GET['user_id'] ) ) {
				$user_id = intval( strip_tags( $_GET['user_id'] ) );

				$saved_slots = get_user_meta( $user_id, 'bb_schedule_slots', true );

				if ( empty( $saved_slots ) ) {
					$saved_slots = [];
				}

				// If the form is not submitted via the Staff Member select field
				if ( ! empty( $_GET['include_staff_member_change'] ) ) {
					if ( isset( $_GET['include_staff_member'] ) ) {
						update_user_meta( $user_id, 'bb_include_on_front_end', 1 );
					} else {
						update_user_meta( $user_id, 'bb_include_on_front_end', 0 );
					}
				}

				include_once( BB_PLUGIN_DIR . 'options/schedule-fields.php' );
			}
		} else {
			$saved_slots = ! empty( get_site_option( 'bb_schedule_slots' ) ) ? get_site_option( 'bb_schedule_slots' ) : [];

			include_once( BB_PLUGIN_DIR . 'options/schedule-fields.php' );
		}


		include_once( BB_PLUGIN_DIR . 'admin/templates/schedule.php' );
	}

	public function render_notifications_page() {
		include_once( BB_PLUGIN_DIR . 'admin/fields/notifications.php' );

		include_once( BB_PLUGIN_DIR . 'admin/templates/notifications.php' );
	}

	public function render_help_page() {
		include_once( BB_PLUGIN_DIR . 'admin/templates/help.php' );
	}
}