<?php
/**
 * Creates the submenu item for the plugin.
 *
 * @package Custom_Admin_Settings
 */

/**
 * Creates the submenu item for the plugin.
 *
 * Registers a new menu item under 'Tools' and uses the dependency passed into
 * the constructor in order to display the page corresponding to this menu item.
 */
class Brindle_Booking_Menu {

		/**
	 * A reference the class responsible for rendering the submenu page.
	 *
	 * @var    Brindle_Booking_Page
	 * @access private
	 */
	private $submenu_page;

	/**
	 * Initializes all of the partial classes.
	 *
	 * @param Brindle_Booking_Page $submenu_page A reference to the class that renders the
	 * page for the plugin.
	 */
	public function __construct( $submenu_page ) {
		$this->submenu_page = $submenu_page;
	}

	/**
	 * Adds a submenu for this plugin to the 'Tools' menu.
	 */
	public function init() {
		 add_action( 'admin_menu', array( $this, 'add_options_pages' ) );
	}

	/**
	 * Creates the submenu item and calls on the Submenu Page object to render
	 * the actual contents of the page.
	 */
	public function add_options_pages() {
		$capabilities = 'manage_options';
		$booking_page_function = 'render_services_page';

		$user = wp_get_current_user();

		if ( in_array( 'mbbb_staff_member', $user->roles ) ) {
			$capabilities = 'read';
			$booking_page_function = 'render_schedule_page';
		}

		$position = 90;
		$subpages = [
			'design'        => 'Design',
			'settings'      => 'Settings',
			'schedule'      => 'Schedule',
			'notifications' => 'Notifications',
			'integrations'  => 'Integrations',
			'help'          => 'Help'
		];

		if ( in_array( 'mbbb_staff_member', $user->roles ) ) {
			$subpages = [
				'schedule'      => 'Schedule',
				'integrations'  => 'Integrations',
			];
		}

		add_submenu_page(
			'my-brindle.php',
			'Brindle Booking Page',
			'Booking',
			'read',
			'brindle-booking',
			array( $this->submenu_page, $booking_page_function ),
			$position
		);

		foreach ( $subpages as $key => $name ) {
			$position += 5;

			$inner_page_capabilities = 'manage_options';

			if ( in_array( 'mbbb_staff_member', $user->roles ) ) {
				$inner_page_capabilities = 'read';
			}

			add_submenu_page(
				'brindle-booking',
				"Brindle Booking {$name} Page",
				$name,
				$inner_page_capabilities,
				"brindle-booking-{$key}",
				array( $this->submenu_page, "render_{$key}_page" ),
				$position
			);

		}

		$appnts_capabilities = 'edit_posts';

		if ( in_array( 'mbbb_staff_member', $user->roles ) ) {
			$appnts_capabilities = 'read';
		}

		add_submenu_page(
			'my-brindle.php',
			'Appointments',
			'Appointments',
			'read',
			'edit.php?post_type=bb_appointment',
			'',
			95
		);
	}
}