<?php

namespace AmeliaBooking\Infrastructure\WP\Translations;

use AmeliaBooking\Infrastructure\Licence;

/**
 * Class BackendStrings
 *
 * @package AmeliaBooking\Infrastructure\WP\Translations
 *
 * @SuppressWarnings(ExcessiveMethodLength)
 * @SuppressWarnings(ExcessiveClassLength)
 * @phpcs:disable
 */
class BackendStrings
{
    /**
     * @var array|null
     */
    protected static $allStrings = null;

    /**
     * Returns a single string by key from all merged strings
     *
     * @param string $key
     *
     * @return string
     */
    public static function get($key)
    {
        if (self::$allStrings === null) {
            self::$allStrings = self::getAllStrings();
        }

        return self::$allStrings[$key] ?? '';
    }

    /**
     * Returns all merged strings (LiteBackendStrings + BackendStrings)
     *
     * @return array
     */
    public static function getAllStrings()
    {
        $labels = [
            '2years'                                          => __('2 years', 'wpamelia'),
            '3years'                                          => __('3 years', 'wpamelia'),
            'activation_activated'                            => __('Plugin has been activated', 'wpamelia'),
            'activation_deactivated'                          => __('Plugin has been deactivated', 'wpamelia'),
            'activation_envato_failed'                        => __('It seems that Envato API is currently busy (please try again) or you don\'t have a valid purchase of Amelia', 'wpamelia'),
            'activation_settings_domains_limit'               => __('You have reached maximum number of registered domains', 'wpamelia'),
            'activation_settings_invalid_code'                => __('The purchase code is invalid or it has expired', 'wpamelia'),
            'allow_customer_delete_profile_tooltip'           => __('Enable this option if you want to allow your customers to delete their profile data (bookings won\'t be deleted).', 'wpamelia'),
            'appointments'                                    => __('Appointments', 'wpamelia'),
            'barion_live_poskey'                              => __('Secret key (POSKey)', 'wpamelia'),
            'barion_sandbox_poskey'                           => __('Sandbox secret key (POSKey)', 'wpamelia'),
            'barion_payee_email'                              => __('Payee email', 'wpamelia'),
            'barion_sandbox_poskey_error'                     => __('Please enter sandbox POSKey', 'wpamelia'),
            'barion_live_poskey_error'                        => __('Please enter live POSKey', 'wpamelia'),
            'barion_payee_email_error'                        => __('Please enter payee email', 'wpamelia'),
            'analytics_event_tooltip'                         => __('Enter the event name that will be sent for tracking purposes.', 'wpamelia'),
            'employee_selection_logic_round_robin'            => __('Round-robin', 'wpamelia'),
            'employee_selection_logic_highest_price'          => __('Highest price', 'wpamelia'),
            'employee_selection_logic_lowest_price'           => __('Lowest price', 'wpamelia'),
            'empty_package_email'                             => __('Notify selected employees about empty package purchases', 'wpamelia'),
            'empty_package_email_tooltip'                     => __('These employees will receive the package purchased e-mail notification when it is purchased without any appointments booked.', 'wpamelia'),
            'enable_microsoft_teams_tooltip'                  => __('Enable this option if you want to include Microsoft Teams in your event.', 'wpamelia'),
            'configure_waiting_list_for_appointments'         => __('Configure waiting list for appointments', 'wpamelia'),
            'country'                                         => __('Country', 'wpamelia'),
            'custom_fields'                                   => __('Custom fields', 'wpamelia'),
            'customers_as_attendees_tooltip_google'           => __('Enable this option to add event attendees to employees’ Google Calendar events.', 'wpamelia'),
            'customers_as_attendees_tooltip_outlook'          => __('Enable this option to add event attendees to employees’ Outlook Calendar events.', 'wpamelia'),
            'customers_as_attendees_tooltip_apple'            => __('Enable this option to add event attendees to employees’ Apple Calendar events.', 'wpamelia'),
            'customer_cabinet_tooltip'                        => __('Enter here URL of the page with [ameliacustomerpanel] shortcode if you want to send it to your customers in notifications. Make sure to also add the placeholder in notification so the URL can be sent.', 'wpamelia'),
            'employee_cabinet_tooltip'                        => __('Enter here URL of the page with [ameliaemployeepanel] shortcode if you want to send it to your employees in notifications. Make sure to also add the placeholder in notification so the URL can be sent.', 'wpamelia'),
            'dashboard'                                       => __('Dashboard', 'wpamelia'),
            'day1'                                            => __('1 day', 'wpamelia'),
            'days2'                                           => __('2 days', 'wpamelia'),
            'days3'                                           => __('3 days', 'wpamelia'),
            'days4'                                           => __('4 days', 'wpamelia'),
            'days5'                                           => __('5 days', 'wpamelia'),
            'days6'                                           => __('6 days', 'wpamelia'),
            'deactivate'                                      => __('Deactivate', 'wpamelia'),
            'enabled'                                         => __('Enabled', 'wpamelia'),
            'endpoint'                                        => __('Endpoint', 'wpamelia'),
            'endpoint_tooltip'                                => __('Enter here an endpoint if you are using Mailgun from EU countries', 'wpamelia'),
            'enter_valid_url_warning'                         => __('Please enter a valid URL with protocol (http:// or https://).', 'wpamelia'),
            'envato_api_activated'                            => __('Activated with Envato', 'wpamelia'),
            'event_description'                               => __('Event description', 'wpamelia'),
            'event_title'                                     => __('Event title', 'wpamelia'),
            'api_key'                                         => __('API Key', 'wpamelia'),
            'api_key_copied'                                  => __('API Key copied to clipboard.', 'wpamelia'),
            'fallback_booking_confirmed_title'                => __('Booking Confirmed', 'wpamelia'),
            'fallback_booking_confirmed_desc'                 => __('Your booking has been successfully completed and approved. You\'re all set and can expect everything to proceed smoothly.', 'wpamelia'),
            'fallback_booking_processed_title'                => __('Booking Processed', 'wpamelia'),
            'fallback_booking_processed_desc'                 => __('Your booking was successfully processed, but it could not be approved. Please contact admin if you need assistance.', 'wpamelia'),
            'fallback_booking_approved_issues_title'          => __('Booking Approved with Issues', 'wpamelia'),
            'fallback_booking_approved_issues_desc'           => __('Your booking was approved, but there was an issue completing the process. Please reach out to admin to ensure everything is properly recorded.', 'wpamelia'),
            'fallback_booking_failed_title'                   => __('Booking Failed', 'wpamelia'),
            'fallback_booking_failed_desc'                    => __('We were unable to process your booking, and it was rejected. Please contact admin if you need help or want to try booking again.', 'wpamelia'),
            'fallback_booking_canceled_title'                 => __('Booking Canceled', 'wpamelia'),
            'fallback_booking_canceled_desc'                  => __('Your booking has been successfully canceled. If you have any questions or wish to reschedule, please contact admin.', 'wpamelia'),
            'fallback_booking_rejected_title'                 => __('Booking Rejected', 'wpamelia'),
            'fallback_booking_rejected_desc'                  => __('You have successfully declined this booking request. The status has been updated in the system.', 'wpamelia'),
            'fallback_cancellation_failed_title'              => __('Cancellation Failed', 'wpamelia'),
            'fallback_cancellation_failed_desc'               => __('We were unable to cancel your booking. Please contact admin for assistance with canceling this booking.', 'wpamelia'),
            'fallback_return_to_home'                         => __('Return to Home', 'wpamelia'),
            'generate_api_key_warning'                        => __('Copy your API key now, as it won\'t be visible again.', 'wpamelia'),
            'marketing_add_tracking'                          => __('Add tracking', 'wpamelia'),
            'marketing_type_warning'                          => __('Please select a type.', 'wpamelia'),
            'google_redirect_uri_tooltip'                     => __('This is the path in your application where users will be redirected after authenticating with Google. Add this URI to your Google project credentials under \'Authorized redirect URIs\'.', 'wpamelia'),
            'outlook_redirect_uri_tooltip'                    => __('This is the path in your application where users will be redirected after authenticating with Outlook. Add this URI to the \'Redirect URIs\' section in your Outlook application settings.', 'wpamelia'),
            'apple_redirect_uri_tooltip'                      => __('This is the path in your application where users will be redirected after authenticating with Apple. Add this URI to your Apple project credentials under \'Redirect URIs\'.', 'wpamelia'),
            'limit_app_per_customer_from'                     => __('Count time from', 'wpamelia'),
            'limit_app_per_customer_from_tt'                  => __("'Booking Date and Time' sets the limit based on when the booking is made, regardless of the appointment date. 'Appointment Date and Time' sets the limit based on the scheduled appointment itself.", 'wpamelia'),
            'limit_app_per_employee'                          => __('Limit appointments per employee', 'wpamelia'),
            'limit_app_per_employee_tt'                       => __('Set this option if you want to limit the number of appointments that an employee can have daily no matter how many appointments ‘fit’ inside the working hours', 'wpamelia'),
            'limit_app_booking_date'                          => __('Appointment date', 'wpamelia'),
            'limit_app_date_booked'                           => __('Booking date', 'wpamelia'),
            'limit_events_per_customer_from_tt'               => __('‘Booking date and time’ will set the limit based on the date when the booking is created, regardless of the event’s date and time.<br>The ‘Event start date and time’ will set it based on the event’s start date and time.', 'wpamelia'),
            'limit_events_booking_date'                       => __('Event start date and time', 'wpamelia'),
            'limit_events_date_booked'                        => __('Booking date', 'wpamelia'),
            'number_of_events'                                => __('Number of events', 'wpamelia'),
            'insert_pending_appointments_tooltip'             => __('Enable this option to display appointments with pending status in employees\' calendars.', 'wpamelia'),
            'pending_appointments_meetings_tooltip'           => __('Enable this option to create meetings for appointments with pending status.', 'wpamelia'),
            'live_api_key'                                    => __('Live API key', 'wpamelia'),
            'live_client_id'                                  => __('Live client ID', 'wpamelia'),
            'live_key_id'                                     => __('Live key ID', 'wpamelia'),
            'live_key_secret'                                 => __('Live key secret', 'wpamelia'),
            'live_publishable_key'                            => __('Live publishable key', 'wpamelia'),
            'live_secret'                                     => __('Live secret', 'wpamelia'),
            'live_secret_key'                                 => __('Live secret key', 'wpamelia'),
            'mailchimp_select_list'                           => __('Mailchimp List', 'wpamelia'),
            'mailchimp_default_checked'                       => __('Preselect the “Subscribe” checkbox', 'wpamelia'),
            'mailchimp_default_checked_tooltip'               => __('When enabled, the “Subscribe” checkbox will be selected by default. Customers can manually uncheck it if they do not wish to join your Mailchimp list.', 'wpamelia'),
            'mailchimp_sign_in'                               => __('Sign In to Mailchimp', 'wpamelia'),
            'mailchimp_sign_out'                              => __('Sign Out of Mailchimp', 'wpamelia'),
            'mailgun_api_key'                                 => __('Mailgun API Key', 'wpamelia'),
            'mailgun_api_key_warning'                         => __('Please enter Mailgun API key', 'wpamelia'),
            'mailgun_domain'                                  => __('Mailgun Domain', 'wpamelia'),
            'mailgun_domain_warning'                          => __('Please enter Mailgun Domain', 'wpamelia'),
            'mollie'                                          => __('Mollie', 'wpamelia'),
            'mollie_test_api_key_error'                       => __('Please enter test API Key', 'wpamelia'),
            'mollie_live_api_key_error'                       => __('Please enter live API Key', 'wpamelia'),
            'months3'                                         => __('3 months', 'wpamelia'),
            'months6'                                         => __('6 months', 'wpamelia'),
            'name'                                            => __('Name', 'wpamelia'),
            'number_of_appointments'                          => __('Number of appointments', 'wpamelia'),
            'number_of_events_returned_tooltip'               => __('Set the maximum number of busy events retrieved from calendar to block bookings in Amelia.', 'wpamelia'),
            'number_of_packages'                              => __('Number of packages', 'wpamelia'),
            'outlook_email_warning'                           => __('Outlook Mailer is not fully configured. Please complete the account setup in the Outlook Integration settings.', 'wpamelia'),
            'payment_links_change_status'                     => __('Auto-Approve Booking After Payment', 'wpamelia'),
            'payment_links_change_status_tooltip'             => __('Automatically update the booking status to "Approved" after a successful payment is completed through the payment link.', 'wpamelia'),
            'payPal_live_client_id_error'                     => __('Please enter live ClientId', 'wpamelia'),
            'payPal_live_secret_error'                        => __('Please enter live Secret', 'wpamelia'),
            'payPal_test_client_id_error'                     => __('Please enter test ClientId', 'wpamelia'),
            'payPal_test_secret_error'                        => __('Please enter test Secret', 'wpamelia'),
            'plugin_not_activated'                            => __('To receive automatic updates license activation is required. Please visit %s to activate Amelia.', 'wpamelia'),
            'razorpay_live_client_id_error'                   => __('Please enter live key id', 'wpamelia'),
            'razorpay_live_secret_error'                      => __('Please enter live key secret', 'wpamelia'),
            'razorpay_test_client_id_error'                   => __('Please enter test key id', 'wpamelia'),
            'razorpay_test_secret_error'                      => __('Please enter test key secret', 'wpamelia'),
            'recaptcha_site_key'                              => __('Google reCAPTCHA v2 site key', 'wpamelia'),
            'recaptcha_site_key_tooltip'                      => __('Paste the site key you received after generating your API key pair in Google reCAPTCHA.', 'wpamelia'),
            'recaptcha_secret'                                => __('Google reCAPTCHA v2 secret key', 'wpamelia'),
            'recaptcha_secret_tooltip'                        => __('Paste the secret key you received after creating your API key pair in Google reCAPTCHA.', 'wpamelia'),
            'remove_google_busy_slots_tooltip'                => __('Prevent bookings during times marked as busy in the employee\'s Google Calendar.', 'wpamelia'),
            'remove_outlook_busy_slots_tooltip'               => __('Block booking times that overlap with busy events in the employee’s Outlook Calendar.', 'wpamelia'),
            'remove_apple_busy_slots_tooltip'                 => __('Block booking times that overlap with busy events in the employee’s Apple Calendar.', 'wpamelia'),
            'require_cabinet_password_tooltip'                => __('If you disable this option, your customers will be able to access customer panel with link that is sent to their email account.', 'wpamelia'),
            'sandbox_mode'                                    => __('Sandbox mode', 'wpamelia'),
            'select_value_warning'                            => __('Please select an option.', 'wpamelia'),
            'send_event_invitation_email_tooltip'             => __('When enabled, customers will receive a Google Calendar invitation for the event.', 'wpamelia'),
            'set_metaData_and_description'                    => __('Set metadata and description', 'wpamelia'),
            'settings_lower'                                  => __('settings', 'wpamelia'),
            'show_attendees_tooltip'                          => __('When enabled, customers will see all attendees listed in their Google Calendar event.', 'wpamelia'),
            'smtp_host'                                       => __('SMTP Host', 'wpamelia'),
            'smtp_host_warning'                               => __('Please enter SMTP host', 'wpamelia'),
            'smtp_password'                                   => __('SMTP Password', 'wpamelia'),
            'smtp_password_warning'                           => __('Please enter SMTP password', 'wpamelia'),
            'smtp_port'                                       => __('SMTP Port', 'wpamelia'),
            'smtp_port_warning'                               => __('Please enter SMTP port', 'wpamelia'),
            'smtp_secure'                                     => __('SMTP Secure', 'wpamelia'),
            'smtp_secure_disabled'                            => __('Disabled', 'wpamelia'),
            'smtp_secure_ssl'                                 => __('SSL', 'wpamelia'),
            'smtp_secure_tls'                                 => __('TLS', 'wpamelia'),
            'smtp_username'                                   => __('SMTP Username', 'wpamelia'),
            'smtp_username_warning'                           => __('Please enter SMTP username', 'wpamelia'),
            'stripe_address_fields'                           => __('Add Stripe address fields', 'wpamelia'),
            'stripe_live_publishable_key_error'               => __('Please enter a live publishable key.', 'wpamelia'),
            'stripe_live_secret_key_error'                    => __('Please enter a live secret key.', 'wpamelia'),
            'stripe_test_publishable_key_error'               => __('Please enter a test publishable key.', 'wpamelia'),
            'stripe_test_secret_key_error'                    => __('Please enter a test secret key.', 'wpamelia'),
            'tax_include'                                     => __('Include Taxes', 'wpamelia'),
            'tax_include_tooltip'                             => __('Tax will be included in price calculation.', 'wpamelia'),
            'tax_exclude'                                     => __('Exclude Taxes', 'wpamelia'),
            'tax_exclude_tooltip'                             => __('Tax will be excluded from price calculation and showed separately.', 'wpamelia'),
            'test_api_key'                                    => __('Test API key', 'wpamelia'),
            'test_client_id'                                  => __('Test client ID', 'wpamelia'),
            'test_mode'                                       => __('Test mode', 'wpamelia'),
            'test_publishable_key'                            => __('Test publishable key', 'wpamelia'),
            'test_secret'                                     => __('Test secret', 'wpamelia'),
            'test_secret_key'                                 => __('Test secret Key', 'wpamelia'),
            'time_frame'                                      => __('Time frame', 'wpamelia'),
            'tracking_ViewContent'                            => __('Load page', 'wpamelia'),
            'tracking_SelectCategory'                         => __('Select category', 'wpamelia'),
            'tracking_SelectService'                          => __('Select service', 'wpamelia'),
            'tracking_SelectEmployee'                         => __('Select employee', 'wpamelia'),
            'tracking_SelectLocation'                         => __('Select location', 'wpamelia'),
            'tracking_SelectPackage'                          => __('Select package', 'wpamelia'),
            'tracking_SelectEvent'                            => __('Select event', 'wpamelia'),
            'tracking_Purchase'                               => __('Complete booking with payment', 'wpamelia'),
            'tracking_Schedule'                               => __('Complete booking without payment', 'wpamelia'),
            'tracking_InitiateCheckout'                       => __('Show checkout form', 'wpamelia'),
            'tracking_InitInfoStep'                           => __('Show customer information form', 'wpamelia'),
            'tracking_type_tooltip'                           => __('Select the action that will trigger the event for tracking.', 'wpamelia'),
            'tracking_parameter_name'                         => __('Property name', 'wpamelia'),
            'tracking_parameter_value'                        => __('Property value', 'wpamelia'),
            'unable_to_deactivate_plugin'                     => __('Unable to deactivate plugin. Please try again later.', 'wpamelia'),
            'url'                                             => __('URL', 'wpamelia'),
            'value'                                           => __('Value', 'wpamelia'),
            'appointments_waiting_list_notice_subtitle'       => __('Configure notifications for waiting list updates', 'wpamelia'),
            'appointments_waiting_list_notice_btn_text'       => __('Go to Notifications', 'wpamelia'),
            'redirect_url_denied'                             => __('Redirect URL (denied)', 'wpamelia'),
            'redirect_url_denied_placeholder'                 => __('Enter redirect URL', 'wpamelia'),
            'redirect_url_denied_tooltip'                     => __('Add a redirect URL for cases when a customer attempts to book a time slot that has already been taken.', 'wpamelia'),
            'wc'                                              => __('Enable integration with WooCommerce', 'wpamelia'),
            'wc_product'                                      => __('WooCommerce Product', 'wpamelia'),
            'wc_product_tooltip'                              => __('Select the WooCommerce product that will be used for this package.', 'wpamelia'),
            'wc_on_site_if_free'                              => __('Hide WooCommerce cart when price is 0', 'wpamelia'),
            'wc_redirect_page'                                => __('Redirect page', 'wpamelia'),
            'wc_redirect_page_1'                              => __('WooCommerce Thank you page', 'wpamelia'),
            'wc_redirect_page_2'                              => __('Amelia Add to calendar page', 'wpamelia'),
            'wc_page'                                         => __('Default page', 'wpamelia'),
            'wc_page_cart'                                    => __('Cart', 'wpamelia'),
            'wc_page_checkout'                                => __('Checkout', 'wpamelia'),
            'wc_rules_add'                                    => __('Add rule', 'wpamelia'),
            'wc_status_draft'                                 => __('Draft', 'wpamelia'),
            'wc_status_pending'                               => __('Pending payment', 'wpamelia'),
            'wc_status_processing'                            => __('Processing', 'wpamelia'),
            'wc_status_on_hold'                               => __('On hold', 'wpamelia'),
            'wc_status_completed'                             => __('Completed', 'wpamelia'),
            'wc_status_cancelled'                             => __('Cancelled', 'wpamelia'),
            'wc_status_refunded'                              => __('Refunded', 'wpamelia'),
            'wc_status_failed'                                => __('Failed', 'wpamelia'),
            'wc_status_update_order'                          => __('Apply on', 'wpamelia'),
            'wc_status_update_order_yes'                      => __('Order update', 'wpamelia'),
            'wc_status_update_order_no'                       => __('Order creation', 'wpamelia'),
            'web_hook_action'                                 => __('Action', 'wpamelia'),
            'web_hook_action_warning'                         => __('Please select an action.', 'wpamelia'),
            'web_hook_booking_completed'                      => __('Booking added', 'wpamelia'),
            'web_hook_booking_rescheduled'                    => __('Booking rescheduled', 'wpamelia'),
            'web_hook_booking_canceled'                       => __('Booking canceled', 'wpamelia'),
            'web_hook_booking_status_updated'                 => __('Booking status changed', 'wpamelia'),
            'web_hook_package_purchased'                      => __('Package purchased', 'wpamelia'),
            'web_hook_package_canceled'                       => __('Package canceled', 'wpamelia'),
            'week1'                                           => __('1 week', 'wpamelia'),
            'weeks2'                                          => __('2 weeks', 'wpamelia'),
            'weeks3'                                          => __('3 weeks', 'wpamelia'),
            'weeks4'                                          => __('4 weeks', 'wpamelia'),
            'whats_new'                                       => __('What\'s New', 'wpamelia'),
            'after'                                           => __('After', 'wpamelia'),
            'before'                                          => __('Before', 'wpamelia'),
            'configure_placeholder'                           => __('Configure placeholder', 'wpamelia'),
            'cron_instruction'                                => __('This notification requires a cron job. Add the line below to your cron configuration.', 'wpamelia'),
            'custom_notification'                             => __('Custom notification', 'wpamelia'),
            'default_content_customer'                        => __('Dear <b>%customer_full_name%</b>, <br><br>Thank you for choosing our company, <br> <b>%company_name%</b>', 'wpamelia'),
            'default_content_customer_sms'                    => __('Dear %customer_full_name%, Thank you for choosing our company, %company_name%', 'wpamelia'),
            'default_content_employee'                        => __('Hi <b>%employee_full_name%</b>, <br><br>Thank you, <br> <b>%company_name%</b>', 'wpamelia'),
            'default_content_employee_sms'                    => __('Hi %employee_full_name%, Thank you, %company_name%', 'wpamelia'),
            'delivered'                                       => __('Delivered', 'wpamelia'),
            'details_changed'                                 => __('Details changed', 'wpamelia'),
            'email'                                           => __('Email', 'wpamelia'),
            'enter_name_warning'                              => __('Please enter a name.', 'wpamelia'),
            'enter_recipient_email_warning'                   => __('Please enter a recipient email.', 'wpamelia'),
            'enter_valid_email_warning'                       => __('Please enter a valid email address.', 'wpamelia'),
            'enter_valid_phone_warning'                       => __('Please enter a valid phone number.', 'wpamelia'),
            'failed'                                          => __('Failed', 'wpamelia'),
            'loading'                                         => __('Loading...', 'wpamelia'),
            'manage_languages'                                => __('Manage languages', 'wpamelia'),
            'languages'                                       => __('Languages', 'wpamelia'),
            'notification_name'                               => __('Notification name', 'wpamelia'),
            'notification_not_saved'                          => __('Notification has not been saved.', 'wpamelia'),
            'notification_deleted'                            => __('Notification has been deleted.', 'wpamelia'),
            'notification_scheduled'                          => __('Scheduled notification', 'wpamelia'),
            'notification_triggered'                          => __('Action-based notification', 'wpamelia'),
            'notification_type'                               => __('Notification type', 'wpamelia'),
            'package_placeholder_label'                       => __('Package appointments details', 'wpamelia'),
            'paddle'                                          => __('Paddle', 'wpamelia'),
            'password_has_been_changed'                       => __('Password has been changed', 'wpamelia'),
            'password_reset_success'                          => __('Your password has been reset successfully.', 'wpamelia'),
            'passwords_do_not_match'                          => __('Passwords don\'t match.', 'wpamelia'),
            'payment_history_error'                           => __('Unable to retrieve payments results', 'wpamelia'),
            'payment_id'                                      => __('Payment ID', 'wpamelia'),
            'payPal'                                          => __('PayPal', 'wpamelia'),
            'ph_appointment_cancel_url'                       => __('Cancel appointment link', 'wpamelia'),
            'ph_appointment_approve_url'                      => __('Approve appointment link', 'wpamelia'),
            'ph_appointment_reject_url'                       => __('Reject appointment link', 'wpamelia'),
            'ph_initial_appointment_date'                     => __('Appointment initial date', 'wpamelia'),
            'ph_initial_appointment_date_time'                => __('Appointment initial date & time', 'wpamelia'),
            'ph_initial_appointment_start_time'               => __('Appointment initial start time', 'wpamelia'),
            'ph_initial_appointment_end_time'                 => __('Appointment initial end time', 'wpamelia'),
            'ph_appointment_deposit_payment'                  => __('Appointment deposit', 'wpamelia'),
            'ph_payment_link_barion'                          => __('Payment link for Barion', 'wpamelia'),
            'ph_payment_link_mollie'                          => __('Mollie payment link', 'wpamelia'),
            'ph_payment_link_paypal'                          => __('PayPal payment link', 'wpamelia'),
            'ph_payment_link_razorpay'                        => __('Razorpay payment link', 'wpamelia'),
            'ph_payment_link_stripe'                          => __('Stripe payment link', 'wpamelia'),
            'ph_payment_link_square'                          => __('Square payment link', 'wpamelia'),
            'ph_payment_link_woocommerce'                     => __('WooCommerce payment link', 'wpamelia'),
            'ph_cart_appointments_details'                    => __('Cart appointments details', 'wpamelia'),
            'ph_coupon_used'                                  => __('Used coupon', 'wpamelia'),
            'ph_customer_cabinet_url'                         => __('Customer panel access link', 'wpamelia'),
            'ph_employee_cabinet_url'                         => __('Employee panel access link', 'wpamelia'),
            'ph_employee_password'                            => __('Employee password', 'wpamelia'),
            'ph_event_cancel_url'                             => __('Cancel event link', 'wpamelia'),
            'ph_event_tickets'                                => __('Event tickets', 'wpamelia'),
            'ph_event_deposit_payment'                        => __('Event deposit', 'wpamelia'),
            'ph_initial_event_start_date'                     => __('Event initial start date', 'wpamelia'),
            'ph_initial_event_start_date_time'                => __('Initial start date & time of the event', 'wpamelia'),
            'ph_initial_event_start_time'                     => __('Initial start time of the event', 'wpamelia'),
            'ph_initial_event_end_date'                       => __('Initial end date of the event', 'wpamelia'),
            'ph_initial_event_end_date_time'                  => __('Initial end date & time of the event', 'wpamelia'),
            'ph_initial_event_end_time'                       => __('Initial end time of the event', 'wpamelia'),
            'ph_extras_details'                               => __('Selected extras details', 'wpamelia'),
            'ph_extras'                                       => __('Selected extras', 'wpamelia'),
            'ph_cart_details_setup'                           => __('Configure the cart appointments details placeholder.', 'wpamelia'),
            'ph_group_appointment_details'                    => __('Group appointment details', 'wpamelia'),
            'ph_group_appointment_setup'                      => __('Configure the group appointment details placeholder.', 'wpamelia'),
            'ph_group_event_setup'                            => __('Configure the group event details placeholder.', 'wpamelia'),
            'ph_lesson_space_url'                             => __('Lesson Space link to join space', 'wpamelia'),
            'ph_lesson_space_url_date'                        => __('Date periods of the event with Lesson Space join links', 'wpamelia'),
            'ph_lesson_space_url_date_time'                   => __('Date & time periods of the event with Lesson Space join links', 'wpamelia'),
            'ph_location_address'                             => __('Location address', 'wpamelia'),
            'ph_location_description'                         => __('Location description', 'wpamelia'),
            'ph_location_name'                                => __('Location name', 'wpamelia'),
            'ph_location_phone'                               => __('Location phone', 'wpamelia'),
            'ph_package_appointments_details'                 => __('Package appointments details', 'wpamelia'),
            'ph_package_name'                                 => __('Package name', 'wpamelia'),
            'ph_package_description'                          => __('Package description', 'wpamelia'),
            'ph_package_details_setup'                        => __('Configure the package appointments details placeholder.', 'wpamelia'),
            'ph_package_duration'                             => __('Package duration', 'wpamelia'),
            'ph_package_price'                                => __('Package price', 'wpamelia'),
            'ph_package_deposit_payment'                      => __('Package deposit', 'wpamelia'),
            'ph_recurring_appointments_details'               => __('Recurring appointments details', 'wpamelia'),
            'ph_recurring_details_setup'                      => __('Configure the recurring appointments details placeholder.', 'wpamelia'),
            'ph_reservation_description'                      => __('Service or event description', 'wpamelia'),
            'ph_reservation_name'                             => __('Service or event name', 'wpamelia'),
            'ph_zoom_host_url'                                => __('Zoom start meeting (hosts) link', 'wpamelia'),
            'ph_zoom_host_url_date'                           => __('Event date periods with Zoom start links', 'wpamelia'),
            'ph_zoom_host_url_date_time'                      => __('Event date & time periods with Zoom start links', 'wpamelia'),
            'ph_zoom_join_url'                                => __('Zoom join meeting (participants) link', 'wpamelia'),
            'ph_zoom_join_url_date'                           => __('Event date periods with Zoom join links', 'wpamelia'),
            'ph_zoom_join_url_date_time'                      => __('Event date & time periods with Zoom join links', 'wpamelia'),
            'ph_google_meet_url_date'                         => __('Event date periods with Google Meet join links', 'wpamelia'),
            'ph_google_meet_url_date_time'                    => __('Event date & time periods with Google Meet join links', 'wpamelia'),
            'ph_google_meet_url'                              => __('Google Meet join link', 'wpamelia'),
            'ph_microsoft_teams_url'                          => __('Microsoft Teams join link', 'wpamelia'),
            'ph_microsoft_teams_url_date'                     => __('Event date periods with Microsoft Teams join links', 'wpamelia'),
            'ph_microsoft_teams_url_date_time'                => __('Event date & time periods with Microsoft Teams join links', 'wpamelia'),
            'packagePlaceholders'                             => __('Package', 'wpamelia'),
            'cartPlaceholders'                                => __('Cart', 'wpamelia'),
            'customFieldsPlaceholders'                        => __('Custom fields', 'wpamelia'),
            'couponsPlaceholders'                             => __('Coupon', 'wpamelia'),
            'placeholder'                                     => __('Placeholder', 'wpamelia'),
            'placeholders'                                    => __('Placeholders', 'wpamelia'),
            'prepared'                                        => __('Prepared', 'wpamelia'),
            'recipient_phone'                                 => __('Recipient phone', 'wpamelia'),
            'recovery_email_sent'                             => __('Password reset link has been sent to your email.', 'wpamelia'),
            'reset_password'                                  => __('Reset password', 'wpamelia'),
            'same_day'                                        => __('On the same day', 'wpamelia'),
            'scheduled_after_appointment'                     => __('Send after appointment', 'wpamelia'),
            'scheduled_after_event'                           => __('Send after event', 'wpamelia'),
            'scheduled_for'                                   => __('Send at', 'wpamelia'),
            'segment_tooltip'                                 => __('GSM (standard Latin) segments contain 160 characters, while UCS-2 (non-GSM - Cyrillic, emoji, non-standard symbols) contain 70 characters, etc.', 'wpamelia'),
            'select_email_template_warning'                   => __('Please select an email template.', 'wpamelia'),
            'send_only_this'                                  => __('Send only this notification', 'wpamelia'),
            'send_only_this_tooltip'                          => __('If enabled, the default notification will not be sent for the selected services.', 'wpamelia'),
            'send_only_this_tooltip_event'                    => __('If enabled, the default notification will not be sent for the selected events.', 'wpamelia'),
            'send_test_whatsapp'                              => __('Test WhatsApp', 'wpamelia'),
            'sender_id_invalid_characters_error'              => __('Special characters are not allowed', 'wpamelia'),
            'sender_id_length_error'                          => __('Sender ID supports up to 11 characters', 'wpamelia'),
            'sender_id_letter_error'                          => __('Your ID must include at least one letter', 'wpamelia'),
            'sender_id_required'                              => __('Alpha sender ID can\'t be empty', 'wpamelia'),
            'sent'                                            => __('Sent', 'wpamelia'),
            'time'                                            => __('Time', 'wpamelia'),
            'undelivered'                                     => __('Undelivered', 'wpamelia'),
            'use_placeholder'                                 => __('Use this placeholder:', 'wpamelia'),
            'view_message'                                    => __('View message', 'wpamelia'),
            'whatsapp_auto_reply_token_tt'                    => __('This is a unique security token. Copy it into the \'Verify token\' field in WhatsApp when creating a webhook.', 'wpamelia'),
            'whatsapp_auto_reply_msg_tt'                      => __('This message is sent when a customer replies via WhatsApp, informing them that responses via WhatsApp are not supported.', 'wpamelia'),
            'whatsapp_default_language_tooltip'               => __('Only templates in the default language will be displayed in the back-end. If a template doesn’t exist in the customer’s language, the default language version will be sent instead.', 'wpamelia'),
            'whatsapp_header'                                 => __('Header', 'wpamelia'),
            'whatsapp_notice_header'                          => __('The message header must be configured in the Facebook Developers settings. The character limit is 60 characters after placeholders are replaced.', 'wpamelia'),
            'whatsapp_notice_body'                            => __('The message body must be configured in the Facebook Developers settings.', 'wpamelia'),
            'whatsapp_template_name'                          => __('Template name', 'wpamelia'),
            'customer_event_qr_code'                          => __('E-ticket', 'wpamelia'),
            'test_whatsapp_error'                             => __('Failed to send test WhatsApp message.', 'wpamelia'),
            'test_whatsapp_success'                           => __('Test WhatsApp message sent successfully', 'wpamelia'),
            'test_sms_error'                                  => __('Failed to send test SMS.', 'wpamelia'),
            'test_sms_success'                                => __('Test SMS sent successfully.', 'wpamelia'),
            'packages_purchased_count'                        => __('Times bought', 'wpamelia'),
            'youtube'                                         => __('YouTube', 'wpamelia'),
            'delete'                                          => __('Delete', 'wpamelia'),
            'duplicate'                                       => __('Duplicate', 'wpamelia'),
            'address'                                         => __('Address', 'wpamelia'),
            'confirm_delete_location'                         => __('Are you sure you want to delete this location?', 'wpamelia'),
            'confirm_duplicate_location'                      => __('Are you sure you want to duplicate this location?', 'wpamelia'),
            'confirm_hide_location'                           => __('Are you sure you want to hide this location?', 'wpamelia'),
            'confirm_show_location'                           => __('Are you sure you want to show this location?', 'wpamelia'),
            'edit_location'                                   => __('Edit location', 'wpamelia'),
            'google_maps_error'                               => __('Google Maps failed to load. Check your API key and restrictions.', 'wpamelia'),
            'latitude'                                        => __('Latitude', 'wpamelia'),
            'location_deleted'                                => __('Location has been deleted.', 'wpamelia'),
            'location_hidden'                                 => __('Location has been hidden.', 'wpamelia'),
            'location_visible'                                => __('Location is now visible.', 'wpamelia'),
            'longitude'                                       => __('Longitude', 'wpamelia'),
            'new_location'                                    => __('New Location', 'wpamelia'),
            'not_right_address'                               => __('Wrong address?', 'wpamelia'),
            'pin_icon'                                        => __('Pin icon', 'wpamelia'),
            'pin_orange'                                      => __('Orange', 'wpamelia'),
            'pin_purple'                                      => __('Purple', 'wpamelia'),
            'pin_red'                                         => __('Red', 'wpamelia'),
            'pin_green'                                       => __('Green', 'wpamelia'),
            'add_duration'                                    => __('Add duration', 'wpamelia'),
            'add_days'                                        => __('Add day(s)', 'wpamelia'),
            'all_employees'                                   => __('All employees', 'wpamelia'),
            'all_locations'                                   => __('All locations', 'wpamelia'),
            'all_services'                                    => __('All services', 'wpamelia'),
            'book_package'                                    => __('Book package', 'wpamelia'),
            'bringing_anyone'                                 => __("'Bringing anyone with you' popup", 'wpamelia'),
            'bringing_anyone_tooltip'                         => __('Disable this option to allow only individual customers to book group appointments, without the ability to bring additional people.', 'wpamelia'),
            'category'                                        => __('Category', 'wpamelia'),
            'confirm_delete_resource'                         => __('Are you sure you want to delete this resource?', 'wpamelia'),
            'confirm_duplicate_resource'                      => __('Are you sure you want to duplicate this resource?', 'wpamelia'),
            'confirm_hide_resource'                           => __('Are you sure you want to hide this resource?', 'wpamelia'),
            'confirm_show_resource'                           => __('Are you sure you want to show this resource?', 'wpamelia'),
            'confirm_delete_package'                          => __('Are you sure you want to delete this package?', 'wpamelia'),
            'confirm_duplicate_package'                       => __('Are you sure you want to duplicate this package?', 'wpamelia'),
            'confirm_hide_package'                            => __('Are you sure you want to hide this package?', 'wpamelia'),
            'confirm_show_package'                            => __('Are you sure you want to show this package?', 'wpamelia'),
            'custom_pricing_enabled'                          => __('Custom Duration & Pricing', 'wpamelia'),
            'edit_package'                                    => __('Edit package', 'wpamelia'),
            'edit_resource'                                   => __('Edit resource', 'wpamelia'),
            'enter_waiting_list_capacity_warning'             => __('Please enter waiting list capacity', 'wpamelia'),
            'waiting_list_capacity_min_warning'               => __('Waiting list capacity must be at least 1', 'wpamelia'),
            'extra_people_limit_min_warning'                  => __('Extra people limit must be 0 or greater', 'wpamelia'),
            'extra_people_limit_max_warning'                  => __('Extra people limit cannot exceed waiting list capacity', 'wpamelia'),
            'maximum_quantity'                                => __('Maximum quantity', 'wpamelia'),
            'aggregated_price'                                => __('Multiply price by number of people', 'wpamelia'),
            'aggregated_price_tooltip'                        => __('If disabled, the price will remain the same regardless of how many people are included in the group appointment.', 'wpamelia'),
            'new_package'                                     => __('New package', 'wpamelia'),
            'new_resource'                                    => __('New resource', 'wpamelia'),
            'package_choose_employees'                        => __('Allow customers to choose employee on the customer panel', 'wpamelia'),
            'package_choose_employees_tooltip'                => __('When disabled, the employee chosen during the first booking will be used for this service throughout the entire package.', 'wpamelia'),
            'package_date_purchased'                          => __('Date purchased', 'wpamelia'),
            'package_details'                                 => __('Package details', 'wpamelia'),
            'package_hidden'                                  => __('Package has been hidden.', 'wpamelia'),
            'package_visible'                                 => __('Package is now visible.', 'wpamelia'),
            'package_deleted'                                 => __('Package has been deleted.', 'wpamelia'),
            'package_price_calculated'                        => __('Calculated', 'wpamelia'),
            'package_price_calculated_text'                   => __('Calculated package price', 'wpamelia'),
            'package_price_custom'                            => __('Custom', 'wpamelia'),
            'period'                                          => __('Period', 'wpamelia'),
            'pricing'                                         => __('Pricing', 'wpamelia'),
            'resource_additional_people'                      => __('Enable resource usage for a group booking', 'wpamelia'),
            'resource_additional_people_tooltip'              => __('Enable this option if you want to count resource quantity usage for each additional person added during the booking.', 'wpamelia'),
            'resource_deleted'                                => __('Resource has been deleted.', 'wpamelia'),
            'resource_hidden'                                 => __('Resource has been hidden.', 'wpamelia'),
            'resource_name_tooltip'                           => __('The resource name is only visible to you and won\'t appear during booking. It\'s used for internal management purposes.', 'wpamelia'),
            'resource_search_placeholder'                     => __('Search Resources', 'wpamelia'),
            'resource_shared'                                 => __('Quantity is shared', 'wpamelia'),
            'resource_shared_tooltip'                         => __('The resource quantity is shared across all selected services, employees, and locations. ', 'wpamelia'),
            'resource_visible'                                => __('Resource is now visible.', 'wpamelia'),
            'quantity'                                        => __('Quantity', 'wpamelia'),
            'schedule_package_minimum'                        => __('Minimum bookings required', 'wpamelia'),
            'schedule_package_maximum'                        => __('Maximum bookings allowed', 'wpamelia'),
            'select_package_service_warning'                  => __('Please select at least one service.', 'wpamelia'),
            'select_service_employee_warning'                 => __('Please select at least one employee.', 'wpamelia'),
            'service_recurring_sub'                           => __('When recurring dates are unavailable', 'wpamelia'),
            'service_recurring_sub_tooltip'                   => __('Choose how Amelia suggests an alternative date when the selected recurring date has no available time slots.', 'wpamelia'),
            'service_recurring_sub_future'                    => __('Suggest next available date', 'wpamelia'),
            'service_recurring_sub_past'                      => __('Suggest previous available date', 'wpamelia'),
            'service_recurring_sub_both'                      => __('Suggest closest available date', 'wpamelia'),
            'service_recurring_payment'                       => __('Recurring appointment payment', 'wpamelia'),
            'service_recurring_payment_tooltip'               => __('Choose how payments are handled for recurring appointments. If payment is collected only for the first one, the remaining appointments are paid on-site.', 'wpamelia'),
            'service_recurring_payment_none'                  => __('Pay only for the first appointment', 'wpamelia'),
            'service_recurring_payment_all'                   => __('Pay for all appointments at once', 'wpamelia'),
            'shared_capacity_tooltip'                         => __('When enabled, the total number of appointments is shared across the entire package instead of being set per service.', 'wpamelia'),
            'update_for_all'                                  => __('Update for all', 'wpamelia'),
            'mandatory_extra_enable'                          => __('Make extra mandatory', 'wpamelia'),
            'min_required_extras'                             => __('Minimum number of required extras', 'wpamelia'),
            'available'                                       => __('Available', 'wpamelia'),
            'apple_client_id'                                 => __('iCloud email address', 'wpamelia'),
            'apple_app_specific_password'                     => __('iCloud app-specific password', 'wpamelia'),
            'break'                                           => __('On Break', 'wpamelia'),
            'busy'                                            => __('Busy', 'wpamelia'),
            'confirm_duplicate_employee'                      => __('Are you sure you want to duplicate this employee?', 'wpamelia'),
            'connect'                                         => __('Connect', 'wpamelia'),
            'dayoff'                                          => __('Day Off', 'wpamelia'),
            'disconnect'                                      => __('Disconnect', 'wpamelia'),
            'disconnect_employee_account'                     => __('Disconnect employee account', 'wpamelia'),
            'employee_calendar_updated_successfully'          => __('Employee calendar has been updated successfully.', 'wpamelia'),
            'employee_calendar_disconnected'                  => __('Employee calendar disconnected successfully', 'wpamelia'),
            'employee_search_placeholder'                     => __('Search employees', 'wpamelia'),
            'enter_location_warning'                          => __('Please select a location.', 'wpamelia'),
            'outlook_sign_in'                                 => __('Sign in with Outlook', 'wpamelia'),
            'outlook_sign_out'                                => __('Sign out from Outlook', 'wpamelia'),
            'overridden_by_employee'                          => __('Overridden by employee', 'wpamelia'),
            'password'                                        => __('Password', 'wpamelia'),
            'stripe_account'                                  => __('Stripe Account', 'wpamelia'),
            'stripe_account_standard'                         => __('Standard Account', 'wpamelia'),
            'stripe_account_express'                          => __('Express Account', 'wpamelia'),
            'use_charge_alert'                                => __('This charge type will not be be used when booking multiple appointments (cart feature or recurring feature) OR when booking event with multiple employees.', 'wpamelia'),
            'use_direct_payment'                              => __('Direct charge', 'wpamelia'),
            'use_transfers_payment'                           => __('Transfer', 'wpamelia'),
            'use_card_payment'                                => __('Card payment', 'wpamelia'),
            'use_transfer_amount'                             => __('Transfer amount (%)', 'wpamelia'),
            'use_direct_amount'                               => __('Application fee amount (%)', 'wpamelia'),
            'use_stripe_connect'                              => __('Stripe Connect', 'wpamelia'),
            'use_charge_type'                                 => __('Charge type', 'wpamelia'),
            'use_charge_type_tooltip'                         => __('Here you can define the charge type that will be used for employees with "Stripe Connected Account"', 'wpamelia'),
            'use_capabilities'                                => __('Express account capabilities', 'wpamelia'),
            'use_capabilities_tooltip'                        => __('Define which capabilities will be requested when creating an Express connected account', 'wpamelia'),
            'note_internal'                                   => __('Note (internal)', 'wpamelia'),
            'check_csv'                                       => __('Please check your .csv file and try again.', 'wpamelia'),
            'download_csv'                                    => __('Download .csv', 'wpamelia'),
            'import_failed'                                   => __('Import Failed', 'wpamelia'),
            'import_partially_successful'                     => __('Import Partially Successful', 'wpamelia'),
            'overwrite_records'                               => __('Overwrite Records', 'wpamelia'),
            'prepared_csv'                                    => __('We\'ve prepared a .csv file with the customers that were not imported. After fixing the issues, you can try again.', 'wpamelia'),
            'skip_import'                                     => __('Skip Import', 'wpamelia'),
            'need_help'                                       => __('Need help?', 'wpamelia'),
            'version'                                         => __('Version ', 'wpamelia'),
            'confirm_refund_payment'                          => __('Are you sure you want to refund this payment?', 'wpamelia'),
            'refund_payment_amount'                           => __('The refund amount will be', 'wpamelia'),
            'deduction'                                       => __('Deduction', 'wpamelia'),
            'deposit'                                         => __('Deposit', 'wpamelia'),
            'expiration_date'                                 => __('Expiration date', 'wpamelia'),
            'invoice_format'                                  => __('Invoice Format', 'wpamelia'),
            'invoice_format_tooltip'                          => __('Choose the invoice format that will be used in notifications and on the customer panel.', 'wpamelia'),
            'invoice_sent'                                    => __('Invoice has been sent.', 'wpamelia'),
            'invoice_sending_failed'                          => __('Failed to send invoice.', 'wpamelia'),
            'paid'                                            => __('Paid', 'wpamelia'),
            'active'                                          => __('Active', 'wpamelia'),
            'all_extras'                                      => __('All extras', 'wpamelia'),
            'all_packages'                                    => __('All packages', 'wpamelia'),
            'amount_fixed'                                    => __('Fixed amount', 'wpamelia'),
            'amount_percentage'                               => __('Percentage', 'wpamelia'),
            'badge_color'                                     => __('Badge color', 'wpamelia'),
            'badge_label'                                     => __('Badge label', 'wpamelia'),
            'bookings'                                        => __('Bookings', 'wpamelia'),
            'canceled_by_admin'                               => __('Canceled By Admin', 'wpamelia'),
            'canceled_by_attendee'                            => __('Canceled By Attendee', 'wpamelia'),
            'confirm'                                         => __('Confirm', 'wpamelia'),
            'custom_days'                                     => __('Specific date & time', 'wpamelia'),
            'csv_delimiter_semicolon'                         => __('Semicolon (;)', 'wpamelia'),
            'coupon'                                          => __('Coupon', 'wpamelia'),
            'coupon_unknown'                                  => __('The coupon you entered is not valid', 'wpamelia'),
            'create_new_badge'                                => __('Create new badge', 'wpamelia'),
            'date_specific'                                   => __('Specific Date', 'wpamelia'),
            'expired'                                         => __('Expired', 'wpamelia'),
            'discard'                                         => __('Discard', 'wpamelia'),
            'discount'                                        => __('Discount (%)', 'wpamelia'),
            'fully_booked'                                    => __('Fully booked', 'wpamelia'),
            'appointment_space_name_tt'                       => __('Name of the space (room) that will be created for appointments. You can use placeholders from the Notifications page. If left empty, the space will be named after the appointment ID.', 'wpamelia'),
            'lesson_space_pending_tt'                         => __('Enable this option to create spaces for appointments with pending status.', 'wpamelia'),
            'lesson_space_link'                               => __('Lesson Space link', 'wpamelia'),
            'manage_badges'                                   => __('Manage badges', 'wpamelia'),
            'package'                                         => __('Package', 'wpamelia'),
            'package_price'                                   => __('Package price', 'wpamelia'),
            'percentage'                                      => __('Percentage', 'wpamelia'),
            'php_version_message'                             => __('<p>The <strong>Amelia</strong> plugin requires PHP version 5.5 or greater.</p>', 'wpamelia'),
            'php_version_title'                               => __('Plugin Activation Error', 'wpamelia'),
            'elementor_popup_notice'                          => __('Please use the built-in Elementor shortcode widget instead of Amelia widget when adding Amelia to a popup', 'wpamelia'),
            'profile'                                         => __('Hide Employee Profile', 'wpamelia'),
            'recurring_type_daily'                            => __('Daily', 'wpamelia'),
            'recurring_type_monthly'                          => __('Monthly', 'wpamelia'),
            'recurring_type_weekly'                           => __('Weekly', 'wpamelia'),
            'recurring_type_yearly'                           => __('Yearly', 'wpamelia'),
            'refund'                                          => __('Refund', 'wpamelia'),
            'rescheduled'                                     => __('Rescheduled', 'wpamelia'),
            'resource'                                        => __('Resource', 'wpamelia'),
            'required_field'                                  => __('This field is required.', 'wpamelia'),
            'recurring_every'                                 => __('Every', 'wpamelia'),
            'sort'                                            => __('Sort', 'wpamelia'),
            'start_date'                                      => __('Start date', 'wpamelia'),
            'zoom_user'                                       => __('Zoom user', 'wpamelia'),
            'zoom_warning'                                    => __('Some employees assigned to this service are not connected to Zoom. Please go to their profiles and connect them to Zoom to use this integration properly.', 'wpamelia'),
            'zoom_warning_event'                              => __('Some employees assigned to this event are not connected to Zoom. Please go to their profiles and connect them to Zoom to use this integration properly.', 'wpamelia'),
            'unlimited'                                       => __('Unlimited', 'wpamelia'),
            'wc_order'                                        => __('Order', 'wpamelia'),
            'wc_order_id'                                     => __('WooCommerce Order Id', 'wpamelia'),
            'wc_order_id_export'                              => __('Woo Order Id', 'wpamelia'),
            'warning'                                         => __('Warning', 'wpamelia'),
            'week_days'                                       => __('Day of the week', 'wpamelia'),
            'e_ticket_scanner'                                => __('E-ticket scanner', 'wpamelia'),
            'ticket_id'                                       => __('Ticket ID', 'wpamelia'),
            'ticket_is_valid'                                 => __('Ticket is valid', 'wpamelia'),
            'ticket_not_valid_for_date'                       => __('Ticket cannot be scanned for this date', 'wpamelia'),
            'ticket_not_valid'                                => __('Ticket not valid', 'wpamelia'),
            'ticket_not_found'                                => __('Ticket not found', 'wpamelia'),
            'ticket_name'                                     => __('Ticket Name', 'wpamelia'),
            'ticket_already_scanned'                          => __('Ticket has already been scanned', 'wpamelia'),
            'group_ticket_already_scanned'                    => __('Group ticket has already been scanned', 'wpamelia'),
            'all_already_scanned'                             => __('All tickets have already been scanned', 'wpamelia'),
            'booking_id'                                      => __('Booking ID', 'wpamelia'),
            'attendees_allowed'                               => __('Attendees Allowed', 'wpamelia'),
            'start_scanner'                                   => __('Start scanner', 'wpamelia'),
            'stop_scanner'                                    => __('Stop scanner', 'wpamelia'),
            'ticket_code'                                     => __('Ticket code', 'wpamelia'),
            'validate_ticket'                                 => __('Validate ticket', 'wpamelia'),
            'camera_error_1'                                  => __('Camera permission denied. Please allow camera access and try again.', 'wpamelia'),
            'camera_error_2'                                  => __('No camera found on this device.', 'wpamelia'),
            'camera_error_3'                                  => __('Camera not supported by this browser.', 'wpamelia'),
            'camera_error_4'                                  => __('Failed to access camera. Please try again.', 'wpamelia'),
            'checked_in'                                      => __('Checked in', 'wpamelia'),
            'to_upper'                                        => __('To', 'wpamelia'),
            'ticket_type'                                     => __('Ticket Type', 'wpamelia'),
            'confirm_delete_tax'                              => __('Are you sure you want to delete this tax?', 'wpamelia'),
            'confirm_hide_tax'                                => __('Are you sure you want to hide this tax?', 'wpamelia'),
            'confirm_show_tax'                                => __('Are you sure you want to show this tax?', 'wpamelia'),
            'invoice_details'                                 => __('Invoice details', 'wpamelia'),
            'tax_deleted'                                     => __('Tax has been deleted.', 'wpamelia'),
            'tax_hidden'                                      => __('Tax has been hidden.', 'wpamelia'),
            'tax_visible'                                     => __('Tax is now visible.', 'wpamelia'),
            'edit_tax'                                        => __('Edit Tax', 'wpamelia'),
            'finance_taxes_search_placeholder'                => __('Search Taxes', 'wpamelia'),
            'new_tax'                                         => __('New tax', 'wpamelia'),
            'code'                                            => __('Code', 'wpamelia'),
            'code_tooltip'                                    => __('Create a coupon code customers can enter during booking to get a discount.', 'wpamelia'),
            'confirm_delete_coupon'                           => __('Are you sure you want to delete this coupon?', 'wpamelia'),
            'confirm_duplicate_coupon'                        => __('Are you sure you want to duplicate this coupon?', 'wpamelia'),
            'confirm_hide_coupon'                             => __('Are you sure you want to hide this coupon?', 'wpamelia'),
            'confirm_show_coupon'                             => __('Are you sure you want to show this coupon?', 'wpamelia'),
            'coupon_deleted'                                  => __('Coupon has been deleted.', 'wpamelia'),
            'coupon_hidden'                                   => __('Coupon has been hidden.', 'wpamelia'),
            'coupon_visible'                                  => __('Coupon is now visible.', 'wpamelia'),
            'coupons'                                         => __('Coupons', 'wpamelia'),
            'download'                                        => __('Download', 'wpamelia'),
            'download_pdf'                                    => __('Download PDF', 'wpamelia'),
            'download_xml'                                    => __('Download XML', 'wpamelia'),
            'edit_coupon'                                     => __('Edit Coupon', 'wpamelia'),
            'enter_coupon_code_warning'                       => __('Please enter a code.', 'wpamelia'),
            'finance_coupons_search_placeholder'              => __('Search Coupons', 'wpamelia'),
            'invoice'                                         => __('Invoice', 'wpamelia'),
            'invoice_additional_information'                  => __('Additional information', 'wpamelia'),
            'invoice_item'                                    => __('Item', 'wpamelia'),
            'invoice_unit_price'                              => __('Unit price', 'wpamelia'),
            'invoice_incl_tax'                                => __(' (Incl. Tax)', 'wpamelia'),
            'invoice_tax_amount'                              => __('Tax amount', 'wpamelia'),
            'invoice_subtotal'                                => __('Subtotal', 'wpamelia'),
            'invoice_discount'                                => __('Discount', 'wpamelia'),
            'invoice_tax'                                     => __('Tax', 'wpamelia'),
            'invoice_total'                                   => __('Invoice total', 'wpamelia'),
            'invoice_paid'                                    => __('Paid', 'wpamelia'),
            'invoice_left_to_pay'                             => __('Left to pay', 'wpamelia'),
            'invoice_payment_method'                          => __('PAYMENT METHOD', 'wpamelia'),
            'invoice_qty'                                     => __('Qty', 'wpamelia'),
            'invoice_tax_rate'                                => __('Tax rate', 'wpamelia'),
            'invoice_total_item_price'                        => __('Total price', 'wpamelia'),
            'issued'                                          => __('Issued', 'wpamelia'),
            'limit'                                           => __('Limit', 'wpamelia'),
            'new_coupon'                                      => __('New coupon', 'wpamelia'),
            'no_coupon_amount'                                => __('Coupon needs to have discount or deduction', 'wpamelia'),
            'packages_tooltip'                                => __('Select the packages this coupon can be used for.', 'wpamelia'),
            'partiallyPaid'                                   => __('Partially Paid', 'wpamelia'),
            'pending'                                         => __('Pending', 'wpamelia'),
            'preview'                                         => __('Preview', 'wpamelia'),
            'send_invoice'                                    => __('Send invoice', 'wpamelia'),
            'send_invoice_no_email'                           => __('The customer didn’t provide an email address, so the invoice couldn’t be sent.', 'wpamelia'),
            'send_interval'                                   => __('Notification interval', 'wpamelia'),
            'send_interval_tooltip'                           => __('Set the number of approved bookings after which the customer will automatically receive the coupon in a notification. Note: To enable this, the coupon placeholder must be included in the notification template.', 'wpamelia'),
            'send_recurring'                                  => __('Recurring notification', 'wpamelia'),
            'send_recurring_tooltip'                          => __('Enable this option to repeat the notification at the defined interval.', 'wpamelia'),
            'services_tooltip'                                => __('Select the services this coupon can be used for.', 'wpamelia'),
            'events_tooltip'                                  => __('Select the events this coupon can be used for.', 'wpamelia'),
            'times_used'                                      => __('Times used', 'wpamelia'),
            'usage_limit'                                     => __('Usage limit', 'wpamelia'),
            'usage_limit_tooltip'                             => __('Define the total number of uses allowed for this coupon. Once the limit is reached, the coupon becomes inactive.', 'wpamelia'),
            'usage_customer_limit'                            => __('Maximum usage per customer', 'wpamelia'),
            'usage_customer_limit_tooltip'                    => __('Define the maximum number of uses per customer. Once the limit is reached, the coupon will no longer be valid for that customer.', 'wpamelia'),
            'used'                                            => __('Used', 'wpamelia'),
            'appointment_id'                                  => __('Appointment ID', 'wpamelia'),
            'assigned'                                        => __('Assigned', 'wpamelia'),
            'barion'                                          => __('Barion', 'wpamelia'),
            'create_new'                                      => __('Create new', 'wpamelia'),
            'customer_name'                                   => __('Customer name', 'wpamelia'),
            'customer_phone'                                  => __('Customer phone', 'wpamelia'),
            'customers'                                       => __('Customers', 'wpamelia'),
            'customers_in_waiting_list'                       => __('Customers in Waiting list', 'wpamelia'),
            'linked'                                          => __('Linked', 'wpamelia'),
            'group_booking_message'                           => __('By booking this time slot you will book appointment on top of existing group appointment!', 'wpamelia'),
            'price'                                           => __('Price', 'wpamelia'),
            'package_deal'                                    => __('Package deal', 'wpamelia'),
            'pay_pal'                                         => __('PayPal', 'wpamelia'),
            'razorpay'                                        => __('Razorpay', 'wpamelia'),
            'stripe'                                          => __('Stripe', 'wpamelia'),
            'allow_customers_to_pay_total'                    => __('Check this option if you want your customers to have the option to choose whether they will pay the full amount or just a deposit. If unchecked, customers will only be able to pay the deposit during the booking process.', 'wpamelia'),
            'deposit_amount'                                  => __('Deposit amount', 'wpamelia'),
            'deposit_payment'                                 => __('Deposit type', 'wpamelia'),
            'deposit_payment_tooltip'                         => __('A percentage deposit is calculated based on the total booking price. A fixed amount can either be multiplied by the number of people or applied as a single total amount.', 'wpamelia'),
            'deposit_info'                                    => __('The remaining balance can be paid on-site or through a payment link.', 'wpamelia'),
            'deposit_per_person'                              => __('Multiply deposit by number of people', 'wpamelia'),
            'deposit_per_person_tooltip'                      => __('Multiply deposit amount by the number of people in one booking.', 'wpamelia'),
            'allow_total_amount'                              => __('Allow customers to pay full amount', 'wpamelia'),
            'pricing_by_date_enabled'                         => __('Pricing by date range', 'wpamelia'),
            'description'                                     => __('Description', 'wpamelia'),
            'event'                                           => __('Event', 'wpamelia'),
            'event_booking_closes_apply'                      => __('If this option is unchecked, the plugin will calculate the booking closing time based on the time set for the first event.', 'wpamelia'),
            'event_booking_opens_apply'                       => __('If this option is unchecked, the plugin will calculate the booking opening time based on the time set for the first event.', 'wpamelia'),
            'event_recurring_period'                          => __('Repeat event', 'wpamelia'),
            'event_booking_deleted'                           => __('Event booking has been deleted.', 'wpamelia'),
            'custom_pricing_date_warning'                     => __('Set the event period first to enable pricing by date range.', 'wpamelia'),
            'event_date_range_warning'                        => __('Date ranges that are not defined will use the default price from the ticket category.', 'wpamelia'),
            'event_add_date_range'                            => __('Add date range', 'wpamelia'),
            'select'                                          => __('Select', 'wpamelia'),
            'cancel'                                          => __('Cancel', 'wpamelia'),
            'scan_e_ticket'                                   => __('Scan e-ticket', 'wpamelia'),
            'e_ticket'                                        => __('E-ticket', 'wpamelia'),
            'event_canceled'                                  => __('Event has been canceled', 'wpamelia'),
            'day'                                             => __('Day', 'wpamelia'),
            'list'                                            => __('List', 'wpamelia'),
            'month'                                           => __('Month', 'wpamelia'),
            'today'                                           => __('Today', 'wpamelia'),
            'week'                                            => __('Week', 'wpamelia'),
            'add_appointment'                                 => __('Add appointment', 'wpamelia'),
            'add_option'                                      => __('Add option', 'wpamelia'),
            'all_bookings'                                    => __('All bookings', 'wpamelia'),
            'address_as_location'                             => __('Google/Outlook location', 'wpamelia'),
            'address_as_location_tooltip'                     => __('Enable this option to use this custom field as the location in Google and Outlook Calendar events, ICS files, and ‘Add to Calendar’ events.', 'wpamelia'),
            'address_disabled_tooltip'                        => __('Set your Google Map API Key in General Settings', 'wpamelia'),
            'address_warning'                                 => __('For this field to work correctly, please add your Google Maps API key in the General Settings. Otherwise, it will function as a simple text field.', 'wpamelia'),
            'all_events'                                      => __('All events', 'wpamelia'),
            'any_employee'                                    => __('Any Employee', 'wpamelia'),
            'any_location'                                    => __('Any Location', 'wpamelia'),
            'auto_fill_your_details'                          => __('Auto-fill your details using:', 'wpamelia'),
            'btn_type_filled'                                 => __('filled', 'wpamelia'),
            'btn_type_plain'                                  => __('plain', 'wpamelia'),
            'btn_type_text'                                   => __('text', 'wpamelia'),
            'number_of_additional_persons'                    => __('Number of Additional People', 'wpamelia'),
            'one_person'                                      => __('Person', 'wpamelia'),
            'one_persons'                                     => __('People', 'wpamelia'),
            'extra_colon'                                     => __('Extra', 'wpamelia'),
            'select_extra'                                    => __('John Doe', 'wpamelia'),
            'select_extra2'                                   => __('Jane Doe', 'wpamelia'),
            'qty_colon'                                       => __('Qty', 'wpamelia'),
            'price_colon'                                     => __('Price', 'wpamelia'),
            'colors_and_fonts'                                => __('Colors & Fonts', 'wpamelia'),
            'continue'                                        => __('Continue', 'wpamelia'),
            'coupon_input_field'                              => __('Coupon field', 'wpamelia'),
            'custom_field'                                    => __('Custom Field', 'wpamelia'),
            'custom_field_lower'                              => __('Custom field', 'wpamelia'),
            'custom_fields_added'                             => __('Custom field has been added', 'wpamelia'),
            'custom_fields_deleted'                           => __('Custom field has been deleted.', 'wpamelia'),
            'custom_fields_positions_saved_fail'              => __('Unable to save custom fields positions', 'wpamelia'),
            'custom_field_saved'                              => __('Custom field has been saved', 'wpamelia'),
            'download_invoice'                                => __('Download invoice', 'wpamelia'),
            'first_booking_only'                              => __('First booking only', 'wpamelia'),
            'visible_at'                                      => __('Visible at', 'wpamelia'),
            'label'                                           => __('Label', 'wpamelia'),
            'label_name'                                      => __('Label name', 'wpamelia'),
            'include_in_invoice'                              => __('Include in invoice', 'wpamelia'),
            'notification_placeholder'                        => __('Notification Placeholder', 'wpamelia'),
            'or_enter_details_below'                          => __('Or enter details below', 'wpamelia'),
            'service'                                         => __('Service', 'wpamelia'),
            'primary_gradient'                                => __('Primary Gradient', 'wpamelia'),
            'required'                                        => __('Required', 'wpamelia'),
            'parts'                                           => __('Parts', 'wpamelia'),
            'send_custom_fields_separately'                   => __('Send custom fields info for each customer separately', 'wpamelia'),
            'send_custom_fields_tooltip'                      => __('Enable this option if you want your employee to receive data from the custom fields only for the last customer when there is a group booking', 'wpamelia'),
            'global_customize_settings_notice'                => __('Global Settings apply only to the Event Calendar and Search Booking forms, to customize other booking forms use the settings on the right.', 'wpamelia'),
            'service_option'                                  => __('Service', 'wpamelia'),
            'employee_option'                                 => __('Employee', 'wpamelia'),
            'location_option'                                 => __('Location', 'wpamelia'),
            'package_option'                                  => __('Package', 'wpamelia'),
            'recurring_repeat'                                => __('Repeat:', 'wpamelia'),
            'repeat_daily'                                    => __('Daily', 'wpamelia'),
            'repeat_weekly'                                   => __('Weekly', 'wpamelia'),
            'repeat_monthly'                                  => __('Monthly', 'wpamelia'),
            'recurring_day'                                   => __('Day', 'wpamelia'),
            'recurring_days'                                  => __('Days', 'wpamelia'),
            'recurring_week'                                  => __('Week', 'wpamelia'),
            'recurring_weeks'                                 => __('Weeks', 'wpamelia'),
            'recurring_month'                                 => __('Month', 'wpamelia'),
            'recurring_months'                                => __('Months', 'wpamelia'),
            'recurring_on'                                    => __('On:', 'wpamelia'),
            'recurring_times'                                 => __('Time(s):', 'wpamelia'),
            'recurring_appointments'                          => __('Recurring appointments', 'wpamelia'),
            'recurring_edit'                                  => __('You can edit or delete each appointment', 'wpamelia'),
            'date'                                            => __('Date', 'wpamelia'),
            'employee'                                        => __('Employee', 'wpamelia'),
            'date_colon'                                      => __('Date:', 'wpamelia'),
            'time_colon'                                      => __('Local time:', 'wpamelia'),
            'location_colon'                                  => __('Location:', 'wpamelia'),
            'location_name'                                   => __('Location 1', 'wpamelia'),
            'every_day_until'                                 => __('Every Day until', 'wpamelia'),
            'birthday_input_field'                            => __('Birthday', 'wpamelia'),
            'recurring_string'                                => __('Every Day until', 'wpamelia'),
            'payment_method_colon'                            => __('Payment method:', 'wpamelia'),
            'payment_btn_on_site'                             => __('On-site', 'wpamelia'),
            'payment_btn_stripe'                              => __('Stripe', 'wpamelia'),
            'payment_btn_mollie'                              => __('Online', 'wpamelia'),
            'payment_type_colon'                              => __('Payment Type:', 'wpamelia'),
            'payment_on_site'                                 => __('On-site', 'wpamelia'),
            'payment_paypal'                                  => __('PayPal', 'wpamelia'),
            'payment_credit_card'                             => __('Credit Card', 'wpamelia'),
            'credit_or_debit_card_colon'                      => __('Credit or debit card:', 'wpamelia'),
            'payment_card_number'                             => __('Card number', 'wpamelia'),
            'total_number_of_persons'                         => __('Total number of people:', 'wpamelia'),
            'base_price_colon'                                => __('Base Price:', 'wpamelia'),
            'discount_amount_colon'                           => __('Discount', 'wpamelia'),
            'total_cost_colon'                                => __('Total Cost:', 'wpamelia'),
            'please_select_package'                           => __('Please select package:', 'wpamelia'),
            'package_colon'                                   => __('Package:', 'wpamelia'),
            'back'                                            => __('Back', 'wpamelia'),
            'package_book_service'                            => __('All services are booked separately', 'wpamelia'),
            'package_min_book'                                => __('appointment is required to be booked now.', 'wpamelia'),
            'package_min_book_plural'                         => __('appointments are required to be booked now.', 'wpamelia'),
            'preview_invoice'                                 => __('Preview invoice', 'wpamelia'),
            'no_selected_slot_requirements'                   => __('Select date and time', 'wpamelia'),
            'package_list_overview'                           => __('Overview', 'wpamelia'),
            'end_time_visibility'                             => __('End Time Visibility:', 'wpamelia'),
            'any_employee_visibility'                         => __('Any Employee Option Visibility:', 'wpamelia'),
            'event_capacity'                                  => __('Capacity', 'wpamelia'),
            'event_date'                                      => __('Event Date and Time', 'wpamelia'),
            'event_about'                                     => __('About this event', 'wpamelia'),
            'event_book'                                      => __('Book this event', 'wpamelia'),
            'event_book_persons'                              => __('Number of people', 'wpamelia'),
            'categories'                                      => __('Categories', 'wpamelia'),
            'services_lower'                                  => __('services', 'wpamelia'),
            'service_images_thumbs'                           => __('Image thumbs', 'wpamelia'),
            'view_more'                                       => __('View more', 'wpamelia'),
            'service_employees_list'                          => __('Service employees list', 'wpamelia'),
            'package_badge'                                   => __('Package badge', 'wpamelia'),
            'package_services_list'                           => __('Package services list', 'wpamelia'),
            'h'                                               => __('h', 'wpamelia'),
            'min'                                             => __('min', 'wpamelia'),
            'service_info'                                    => __('Service Info', 'wpamelia'),
            'maximum_quantity_colon'                          => __('Maximum Quantity:', 'wpamelia'),
            'description_colon'                               => __('Description:', 'wpamelia'),
            'category_colon'                                  => __('Category:', 'wpamelia'),
            'capacity_colon'                                  => __('Capacity:', 'wpamelia'),
            'package_book_duration'                           => __('The package is time-limited to', 'wpamelia'),
            'package_rules_description'                       => __('Package rules and description', 'wpamelia'),
            'selected_services'                               => __('Selected services', 'wpamelia'),
            'time_zone'                                       => __('Time zone', 'wpamelia'),
            'booking_completed_approved'                      => __('Thank you! Your booking is completed.', 'wpamelia'),
            'booking_completed_pending'                       => __('Thank you! Your booking is completed and now is pending confirmation.', 'wpamelia'),
            'select_calendar'                                 => __('Select Calendar', 'wpamelia'),
            'form_colors'                                     => __('Form colors', 'wpamelia'),
            'form_type_event_list'                            => __('Event List Booking Form', 'wpamelia'),
            'form_type_event_calendar'                        => __('Event Calendar Booking Form', 'wpamelia'),
            'event_employee'                                  => __('Event employee', 'wpamelia'),
            'event_spot'                                      => __('Spot', 'wpamelia'),
            'event_spots_left'                                => __('Spots', 'wpamelia'),
            'ev_spot'                                         => __('Spot', 'wpamelia'),
            'ev_spots'                                        => __('Spots', 'wpamelia'),
            'ev_no_spots'                                     => __('No spots left', 'wpamelia'),
            'ev_spots_number'                                 => __('Spots capacity', 'wpamelia'),
            'event_day'                                       => __('Day', 'wpamelia'),
            'event_book_now'                                  => __('Book now', 'wpamelia'),
            'event_upcoming_empty'                            => __('There are no upcoming events for this period', 'wpamelia'),
            'event_capacity_block'                            => __('Capacity', 'wpamelia'),
            'event_location_block'                            => __('Location', 'wpamelia'),
            'event_price_block'                               => __('Price', 'wpamelia'),
            'event_day_block'                                 => __('Event Day', 'wpamelia'),
            'event_range_block'                               => __('Date range', 'wpamelia'),
            'event_show_more'                                 => __('Show more', 'wpamelia'),
            'event_show_less'                                 => __('Show less', 'wpamelia'),
            'event_schedule'                                  => __('Schedule:', 'wpamelia'),
            'event_hosted_by'                                 => __('Hosted by:', 'wpamelia'),
            'event_many_people'                               => __('How many people are coming?', 'wpamelia'),
            'form_type_catalog'                               => __('Catalog Booking Form', 'wpamelia'),
            'form_block_package'                              => __('Package', 'wpamelia'),
            'form_block_catalog'                              => __('Catalog', 'wpamelia'),
            'form_block_catalog_service'                      => __('Catalog Service', 'wpamelia'),
            'form_block_catalog_package'                      => __('Catalog Package', 'wpamelia'),
            'show_single_event'                               => __('Show single Event details on the page', 'wpamelia'),
            'payment_type_deposit_only'                       => __('Deposit only', 'wpamelia'),
            'payment_type_full_amount'                        => __('Whole amount', 'wpamelia'),
            'font_url'                                        => __('Font URL', 'wpamelia'),
            'payment_method_view'                             => __('"Payment Method" View', 'wpamelia'),
            'employee_colon'                                  => __('Employee', 'wpamelia'),
            'please_select_employee'                          => __('Please select employee', 'wpamelia'),
            'please_select_location'                          => __('Please select a location', 'wpamelia'),
            'bringing_anyone_title'                           => __('Bringing anyone with you?', 'wpamelia'),
            'add_people'                                      => __('Number of people that are coming with you.', 'wpamelia'),
            'add_people_total'                                => __('The total number of people for the booking.', 'wpamelia'),
            'bringing_yes'                                    => __('Yes', 'wpamelia'),
            'bringing_no'                                     => __('No', 'wpamelia'),
            'bringing_price'                                  => __('Pricing by the number of people', 'wpamelia'),
            'package_selection'                               => __('Package Selection', 'wpamelia'),
            'package_heading'                                 => __('Hey, there are special packages with this service, check them out!', 'wpamelia'),
            'discount_save'                                   => __('Save', 'wpamelia'),
            'separator_or'                                    => __('Or', 'wpamelia'),
            'continue_without_package'                        => __('Skip packages and continue with the selected service', 'wpamelia'),
            'package_info_step'                               => __('Package Info', 'wpamelia'),
            'package_info_discount'                           => __('Save', 'wpamelia'),
            'expires_at'                                      => __('Expires at', 'wpamelia'),
            'expires_after'                                   => __('Expires after', 'wpamelia'),
            'expires_day'                                     => __('day', 'wpamelia'),
            'expires_days'                                    => __('days', 'wpamelia'),
            'expires_week'                                    => __('week', 'wpamelia'),
            'expires_weeks'                                   => __('weeks', 'wpamelia'),
            'expires_month'                                   => __('month', 'wpamelia'),
            'expires_months'                                  => __('months', 'wpamelia'),
            'without_expiration'                              => __('Without expiration', 'wpamelia'),
            'multiple_locations'                              => __('Multiple locations', 'wpamelia'),
            'package_info_includes'                           => __('includes', 'wpamelia'),
            'package_info_employees'                          => __('Employees', 'wpamelia'),
            'package_appointment_step'                        => __('Appointments', 'wpamelia'),
            'package_appointment_required'                    => __('Number of appointments required for booking', 'wpamelia'),
            'package_appointment_remaining'                   => __('The rest of the appointments can be booked later on the Customers panel.', 'wpamelia'),
            'package_appointment_employee'                    => __('Employee', 'wpamelia'),
            'package_select_employee'                         => __('Select employee', 'wpamelia'),
            'package_appointment_location'                    => __('Location', 'wpamelia'),
            'package_select_location'                         => __('Select location', 'wpamelia'),
            'package_appointments'                            => __('Appointments', 'wpamelia'),
            'package_appointments_date'                       => __('Date and time', 'wpamelia'),
            'package_appointments_select'                     => __('Select', 'wpamelia'),
            'package_appointments_selected'                   => __('Selected', 'wpamelia'),
            'package_appointments_add_more'                   => __('Add more appointments', 'wpamelia'),
            'package_appointments_slots_selected'             => __('All slots are selected', 'wpamelia'),
            'package_booking_overview'                        => __('Booking Overview', 'wpamelia'),
            'package_overview_all_selected'                   => __('All appointments are selected', 'wpamelia'),
            'package_overview_selected_later'                 => __('All appointments will be selected later', 'wpamelia'),
            'package_overview_info'                           => __('Appointment information', 'wpamelia'),
            'package_overview_date'                           => __('Date', 'wpamelia'),
            'package_overview_time'                           => __('Time', 'wpamelia'),
            'package_overview_employee'                       => __('Employee', 'wpamelia'),
            'package_overview_location'                       => __('Location', 'wpamelia'),
            'extras'                                          => __('Extras', 'wpamelia'),
            'extras_available'                                => __('Extras available', 'wpamelia'),
            'min_req_extras_colon'                            => __('Minimum required extras', 'wpamelia'),
            'extras_card_open'                                => __('Learn More', 'wpamelia'),
            'extras_card_close'                               => __('Hide', 'wpamelia'),
            'repeat_appointment'                              => __('Repeat appointment', 'wpamelia'),
            'repeat_appointment_quest'                        => __('Do you want to repeat this appointment?', 'wpamelia'),
            'recurring_step'                                  => __('Recurring appointment', 'wpamelia'),
            'recurrence'                                      => __('Recurrence', 'wpamelia'),
            'recurrence_choosing_time'                        => __('Choose time you want to repeat appointment', 'wpamelia'),
            'repeat_every'                                    => __('Repeat every', 'wpamelia'),
            'recurrence_day'                                  => __('day', 'wpamelia'),
            'recurrence_week'                                 => __('week', 'wpamelia'),
            'recurrence_month'                                => __('month', 'wpamelia'),
            'recurrence_days'                                 => __('days', 'wpamelia'),
            'recurrence_weeks'                                => __('weeks', 'wpamelia'),
            'recurrence_months'                               => __('months', 'wpamelia'),
            'recurrence_repeat_on'                            => __('Repeat on', 'wpamelia'),
            'recurrence_specific_date'                        => __('Specific date', 'wpamelia'),
            'recurrence_first'                                => __('First', 'wpamelia'),
            'recurrence_second'                               => __('Second', 'wpamelia'),
            'recurrence_third'                                => __('Third', 'wpamelia'),
            'recurrence_fourth'                               => __('Fourth', 'wpamelia'),
            'recurring_fifth'                                 => __('Fifth', 'wpamelia'),
            'recurrence_last'                                 => __('Last', 'wpamelia'),
            'recurrence_ends'                                 => __('Ends', 'wpamelia'),
            'recurrence_choose_ends'                          => __('Choose when the repeating ends', 'wpamelia'),
            'number_of_recurrences'                           => __('Number of recurrences:', 'wpamelia'),
            'recurrence_on'                                   => __('On', 'wpamelia'),
            'recurrence_each'                                 => __('On the same day each month', 'wpamelia'),
            'recurrence_select_date'                          => __('Select date', 'wpamelia'),
            'recurrence_after'                                => __('After', 'wpamelia'),
            'occurrences'                                     => __('Occurrences', 'wpamelia'),
            'appointment_repeats'                             => __('Appointment repeats', 'wpamelia'),
            'recurrence_every'                                => __('Every', 'wpamelia'),
            'repeats_on'                                      => __('on', 'wpamelia'),
            'repeats_at'                                      => __('at', 'wpamelia'),
            'repeats_from'                                    => __('from', 'wpamelia'),
            'ends_after'                                      => __('Ends after', 'wpamelia'),
            'ends_on'                                         => __('Ends on', 'wpamelia'),
            'recurring_summary'                               => __('Recurring summary', 'wpamelia'),
            'recurring_unavailable_slots'                     => __('Unavailable time slots', 'wpamelia'),
            'recurring_alert_content'                         => __('slots you selected are busy. We offered you the nearest time slots instead.', 'wpamelia'),
            'recurring_chose_date'                            => __('Choose date and time', 'wpamelia'),
            'recurring_delete'                                => __('Delete', 'wpamelia'),
            'recurring_slots_selected'                        => __('All slots are selected', 'wpamelia'),
            'add_coupon_btn'                                  => __('Add', 'wpamelia'),
            'summary_recurrence'                              => __('Recurrence', 'wpamelia'),
            'summary_recurrences'                             => __('Recurrences', 'wpamelia'),
            'summary_extras'                                  => __('Extras', 'wpamelia'),
            'summary_extras_subtotal'                         => __('Extras subtotal', 'wpamelia'),
            'summary_package'                                 => __('Package', 'wpamelia'),
            'paying_now'                                      => __('Paying now', 'wpamelia'),
            'paying_later'                                    => __('Paying later', 'wpamelia'),
            'full_amount_consent'                             => __('I want to pay full amount', 'wpamelia'),
            'card_number_colon'                               => __('Card number', 'wpamelia'),
            'expires_date_colon'                              => __('Expiration date', 'wpamelia'),
            'payment_protected_policy'                        => __('Payment protected by policy and powered by', 'wpamelia'),
            'payment_wc_mollie_sentence'                      => __('You will be redirected to the payment checkout.', 'wpamelia'),
            'congrats_package'                                => __('Package', 'wpamelia'),
            'congrats_panel'                                  => __('Customer panel', 'wpamelia'),
            'beta_caps'                                       => __('BETA', 'wpamelia'),
            'primary'                                         => __('Primary', 'wpamelia'),
            'main_content'                                    => __('Main content', 'wpamelia'),
            'employee_information'                            => __('Employee information', 'wpamelia'),
            'employee_information_package'                    => __('Employee information', 'wpamelia'),
            'select_this_employee'                            => __('Select this employee', 'wpamelia'),
            'select_this_employee_package'                    => __('Select this employee', 'wpamelia'),
            'location_information'                            => __('Location information', 'wpamelia'),
            'fonts_and_colors'                                => __('Fonts and colors', 'wpamelia'),
            'change_colors'                                   => __('Change colors', 'wpamelia'),
            'sub_step_title'                                  => __('Sub step title', 'wpamelia'),
            'heading_content'                                 => __('Heading content', 'wpamelia'),
            'input_field'                                     => __('Input field', 'wpamelia'),
            'cards_and_buttons'                               => __('Cards and buttons', 'wpamelia'),
            'page_content'                                    => __('Page content', 'wpamelia'),
            'card_content'                                    => __('Card content', 'wpamelia'),
            'alert_content'                                   => __('Alert content', 'wpamelia'),
            'popup_title'                                     => __('Popup title', 'wpamelia'),
            'popup_buttons'                                   => __('Popup buttons', 'wpamelia'),
            'primary_btn_type'                                => __('Primary Button Type', 'wpamelia'),
            'secondary_btn_type'                              => __('Secondary Button Type', 'wpamelia'),
            'recurring_popup'                                 => __('Recurring popup', 'wpamelia'),
            'button_type'                                     => __('Button Type', 'wpamelia'),
            'cart_step'                                       => __('Cart', 'wpamelia'),
            'cart_add_button'                                 => __('Book another', 'wpamelia'),
            'cart_view_button'                                => __('View Cart', 'wpamelia'),
            'cart_title'                                      => __('You can find below the appointments you selected for booking. If you want to book more, click on the button below.'),
            'total_price'                                     => __('Total price', 'wpamelia'),
            'back_to_cart_button_type'                        => __('\'Cancel\' button style', 'wpamelia'),
            'add_to_cart_button_type'                         => __('\'Book another\' button style', 'wpamelia'),
            'total_tax_colon'                                 => __('VAT', 'wpamelia'),
            'incl_tax'                                        => __('Incl. VAT', 'wpamelia'),
            'tax_visibility'                                  => __('VAT info', 'wpamelia'),
            'csb_extras_content'                              => __('Set up visibility and labels', 'wpamelia'),
            'csb_cart_content'                                => __('Cart description', 'wpamelia'),
            'csb_recurring_content'                           => __('Set up visibility, button type and labels', 'wpamelia'),
            'scb_recurring_summary'                           => __('Recurring summary', 'wpamelia'),
            'scb_recurring_summary_content'                   => __('Set up visibility, button type and labels', 'wpamelia'),
            'csb_layout_labels_content'                       => __('Layout and labels options', 'wpamelia'),
            'csb_placeholder'                                 => __('placeholder', 'wpamelia'),
            'csb_mandatory'                                   => __('mandatory notice', 'wpamelia'),
            'csb_appointment_reschedule'                      => __('Reschedule appointment', 'wpamelia'),
            'csb_appointment_book'                            => __('Book appointment', 'wpamelia'),
            'csb_appointment_cancel'                          => __('Cancel appointment', 'wpamelia'),
            'csb_event_cancel'                                => __('Cancel event', 'wpamelia'),
            'csb_package_cancel'                              => __('Cancel package', 'wpamelia'),
            'cpb_package'                                     => __('Package selection', 'wpamelia'),
            'cpb_package_content'                             => __('Set up Labels and Buttons', 'wpamelia'),
            'cpb_package_info'                                => __('Package info', 'wpamelia'),
            'cpb_package_info_content'                        => __('Set up Labels and Buttons', 'wpamelia'),
            'cpb_service_appointment'                         => __('Services list, Appointments', 'wpamelia'),
            'cpb_appointments_preview'                        => __('Package appointments', 'wpamelia'),
            'cpb_appointments_preview_content'                => __('Set up Content, Buttons and Labels', 'wpamelia'),
            'cpb_booking_overview'                            => __('Package overview', 'wpamelia'),
            'cpb_booking_overview_content'                    => __('Set up Labels and Buttons', 'wpamelia'),
            'cpb_your_info_content'                           => __('Registration, Telephone Number, Email', 'wpamelia'),
            'cpb_payment_content'                             => __('Payment type, deposit payment...', 'wpamelia'),
            'cb_package_appointments_heading'                 => __('Package appointments', 'wpamelia'),
            'service_input_field'                             => __('Service Input Field', 'wpamelia'),
            'location_input_field'                            => __('Location Input Field', 'wpamelia'),
            'employee_input_field'                            => __('Select employee', 'wpamelia'),
            'location'                                        => __('Location', 'wpamelia'),
            'info'                                            => __('Info', 'wpamelia'),
            'popup_heading'                                   => __('Popup Heading', 'wpamelia'),
            'extras_heading'                                  => __('Extras Heading', 'wpamelia'),
            'extras_description'                              => __('Extras Description', 'wpamelia'),
            'extras_duration'                                 => __('Extras Duration', 'wpamelia'),
            'csb_category_items'                              => __('Services and packages overview', 'wpamelia'),
            'csb_category_items_content'                      => __('Set up Services and Packages view', 'wpamelia'),
            'csb_category_package'                            => __('Package details', 'wpamelia'),
            'csb_category_package_content'                    => __('Set up Package detailed view', 'wpamelia'),
            'cl_card'                                         => __('Card', 'wpamelia'),
            'card_packages_number'                            => __('Package count', 'wpamelia'),
            'cil_filter_buttons'                              => __('Tabs (All / Packages / Services)', 'wpamelia'),
            'employee_btn_type'                               => __('\'View employee\' button style', 'wpamelia'),
            'book_employee_btn_type'                          => __('Book option on employee dialog', 'wpamelia'),
            'employee_dialog'                                 => __('Employee dialog', 'wpamelia'),
            'employee_info'                                   => __('Employee information', 'wpamelia'),
            'book_service'                                    => __('Book this service', 'wpamelia'),
            'package_category'                                => __('Package category', 'wpamelia'),
            'package_duration'                                => __('Package duration', 'wpamelia'),
            'package_capacity'                                => __('Package capacity', 'wpamelia'),
            'package_location'                                => __('Package location', 'wpamelia'),
            'service_capacity'                                => __('Service capacity', 'wpamelia'),
            'service_location'                                => __('Service location', 'wpamelia'),
            'service_employees'                               => __('Employees', 'wpamelia'),
            'package_about'                                   => __('About package', 'wpamelia'),
            'package_employees'                               => __('Employees', 'wpamelia'),
            'package_block'                                   => __('Packages block', 'wpamelia'),
            'cil_filter_employee'                             => __('Employee filter', 'wpamelia'),
            'cil_filter_location'                             => __('Location filter', 'wpamelia'),
            'filter_employee'                                 => __('Filter by employee', 'wpamelia'),
            'filter_location'                                 => __('Filter by location', 'wpamelia'),
            'filter_packages'                                 => __('Packages', 'wpamelia'),
            'filter_services'                                 => __('Services', 'wpamelia'),
            'packages'                                        => __('Packages', 'wpamelia'),
            'view_employees'                                  => __('View employees', 'wpamelia'),
            'save'                                            => __('Save', 'wpamelia'),
            'in_package'                                      => __('In package', 'wpamelia'),
            'about_package'                                   => __('About package', 'wpamelia'),
            'service_available_in_package'                    => __('This service is available in a package', 'wpamelia'),
            'more_packages'                                   => __('View more packages', 'wpamelia'),
            'less_packages'                                   => __('View less packages', 'wpamelia'),
            'package_includes'                                => __('Package includes', 'wpamelia'),
            'employee_price'                                  => __('Employee price', 'wpamelia'),
            'tab_employees'                                   => __('Employees', 'wpamelia'),
            'extras_costs_colon'                              => __('Extras cost:', 'wpamelia'),
            'subtotal_colon'                                  => __('Subtotal:', 'wpamelia'),
            'pay_now'                                         => __('Paying now', 'wpamelia'),
            'pay_later'                                       => __('Left to pay', 'wpamelia'),
            'recurring_costs_colon'                           => __('Recurring appointments:', 'wpamelia'),
            'csb_event_tickets_content'                       => __('Set up visibility and labels of ticket selection', 'wpamelia'),
            'event_calendar'                                  => __('Calendar', 'wpamelia'),
            'event_select_tickets'                            => __('Select tickets', 'wpamelia'),
            'event_tickets_context'                           => __('Select the number of tickets that you want to book for each ticket type', 'wpamelia'),
            'event_ticket_types'                              => __('Ticket types', 'wpamelia'),
            'event_tickets_left'                              => __('tickets left', 'wpamelia'),
            'event_ticket_left'                               => __('ticket left', 'wpamelia'),
            'event_organizer'                                 => __('Organizer', 'wpamelia'),
            'event_tickets'                                   => __('Tickets', 'wpamelia'),
            'coupons_used'                                    => __('Coupon limit reached', 'wpamelia'),
            'coupons_used_description'                        => __('Number of appointments with applied coupon is', 'wpamelia'),
            'congrats_cart'                                   => __('Total services booked', 'wpamelia'),
            'toggle_sidebar'                                  => __('Sidebar', 'wpamelia'),
            'log_out'                                         => __('Log out', 'wpamelia'),
            'reschedule'                                      => __('Reschedule', 'wpamelia'),
            'google_meet_link'                                => __('Google Meet link', 'wpamelia'),
            'microsoft_teams_link'                            => __('Microsoft Teams link', 'wpamelia'),
            'zoom_link'                                       => __('Zoom link', 'wpamelia'),
            'my_profile'                                      => __('My profile', 'wpamelia'),
            'personal_info'                                   => __('Personal information', 'wpamelia'),
            'password_tab'                                    => __('Password', 'wpamelia'),
            'menu_title'                                      => __('Menu', 'wpamelia'),
            'profile_data_success'                            => __('Profile data updated successfully', 'wpamelia'),
            'password_success'                                => __('Password changed successfully', 'wpamelia'),
            'services_dropdown'                               => __('Service', 'wpamelia'),
            'events_dropdown'                                 => __('Event', 'wpamelia'),
            'packages_dropdown'                               => __('Package', 'wpamelia'),
            'providers_dropdown'                              => __('Employee', 'wpamelia'),
            'customers_dropdown'                              => __('Customer', 'wpamelia'),
            'locations_dropdown'                              => __('Location', 'wpamelia'),
            'cancel_appointment'                              => __('Cancel appointment', 'wpamelia'),
            'confirm_cancel_appointment'                      => __('Are you sure you want to cancel this appointment?', 'wpamelia'),
            'package_book_expiration'                         => __('Duration:', 'wpamelia'),
            'package_book_unlimited'                          => __('Unlimited', 'wpamelia'),
            'timetable'                                       => __('Timetable', 'wpamelia'),
            'event_ticket'                                    => __('Ticket', 'wpamelia'),
            'cancel_event'                                    => __('Cancel event', 'wpamelia'),
            'confirm_cancel_event'                            => __('Are you sure you want to cancel your attendance?', 'wpamelia'),
            'appointments_booked'                             => __('Appointments booked', 'wpamelia'),
            'appointment_booked'                              => __('Appointment booked', 'wpamelia'),
            'package_book_expire'                             => __('Valid until', 'wpamelia'),
            'package_deal_expire_in'                          => __('This package deal will expire in', 'wpamelia'),
            'appointments_deal_expire'                        => __('book appointments before the deal expires!', 'wpamelia'),
            'package_cancel'                                  => __('Cancel', 'wpamelia'),
            'cancel_package'                                  => __('Cancel package', 'wpamelia'),
            'confirm_cancel_package'                          => __('Are you sure you want to cancel this package?', 'wpamelia'),
            'pay_now_btn'                                     => __('Pay now', 'wpamelia'),
            'profile_deleted'                                 => __('Profile deleted', 'wpamelia'),
            'welcome_back'                                    => __('Welcome back', 'wpamelia'),
            'enter_credentials'                               => __('Enter your credentials to access your account.', 'wpamelia'),
            'email_or_username'                               => __('Email or Username', 'wpamelia'),
            'enter_email_or_username_warning'                 => __('Please enter email or username', 'wpamelia'),
            'enter_password_warning'                          => __('Please enter a password.', 'wpamelia'),
            'forgot_your_password'                            => __('Forgot your password?', 'wpamelia'),
            'sign_in'                                         => __('Sign In', 'wpamelia'),
            'access_link_send'                                => __('Send access link', 'wpamelia'),
            'access_link_send_description'                    => __('Enter your account email address and we will send you an access link to your inbox.', 'wpamelia'),
            'send'                                            => __('Send', 'wpamelia'),
            'access_link_send_check'                          => __('Check your email', 'wpamelia'),
            'access_link_send_click'                          => __('Click on the activation link in the e-mail we sent to', 'wpamelia'),
            'access_link_send_inbox'                          => __('Did not receive the email? Check your spam filter, or', 'wpamelia'),
            'access_link_send_retry'                          => __('try different email', 'wpamelia'),
            'provider_profile'                                => __('Employee profile', 'wpamelia'),
            'time_slot_unavailable'                           => __('Time slot is unavailable', 'wpamelia'),
            'package_booking_unavailable'                     => __('Booking is unavailable', 'wpamelia'),
            'booking_reschedule_exception'                    => __('The appointment can\'t be rescheduled.', 'wpamelia'),
            'event_staff'                                     => __('Staff', 'wpamelia'),
            'appointment_price'                               => __('Appointment price', 'wpamelia'),
            'appointment_rescheduled'                         => __('Appointment has been rescheduled', 'wpamelia'),
            'appointment_canceled'                            => __('Appointment canceled', 'wpamelia'),
            'booking_cancel_exception'                        => __('Booking can\'t be canceled', 'wpamelia'),
            'booking_added_success'                           => __('Successfully added booking', 'wpamelia'),
            'package_purchase_canceled'                       => __('Purchase is canceled', 'wpamelia'),
            'customer_already_booked_app'                     => __('You have already booked this appointment', 'wpamelia'),
            'tab_title'                                       => __('Tab title', 'wpamelia'),
            'toggled_sidebar'                                 => __('Sidebar', 'wpamelia'),
            'mobile_menu'                                     => __('Mobile menu', 'wpamelia'),
            'delete_profile_button_type'                      => __('\'Delete\' button style', 'wpamelia'),
            'save_changes_button_type'                        => __('\'Save changes\' button style', 'wpamelia'),
            'change_pass_button_type'                         => __('\'Change password\' button style', 'wpamelia'),
            'close_button_type'                               => __('\'Close\' button style', 'wpamelia'),
            'confirm_button_type'                             => __('\'Confirm\' button style', 'wpamelia'),
            'cancel_button_type'                              => __('\'Cancel\' button style', 'wpamelia'),
            'step_message'                                    => __('Step message', 'wpamelia'),
            'item_status'                                     => __('Item status', 'wpamelia'),
            'page_card'                                       => __('Page card', 'wpamelia'),
            'page_messages'                                   => __('Page messages', 'wpamelia'),
            'go_back_btn_type'                                => __('"Go back" Button Type', 'wpamelia'),
            'pay_button_type'                                 => __('"Paying now" Button Type', 'wpamelia'),
            'book_now_button_type'                            => __('"Book now" Button Type', 'wpamelia'),
            'alert_message'                                   => __('Alert message', 'wpamelia'),
            'footer_content'                                  => __('Footer content', 'wpamelia'),
            'sign_in_button_type'                             => __('\'Sign in\' button style', 'wpamelia'),
            'send_button_type'                                => __('\'Send\' button style', 'wpamelia'),
            'new_pass_button_type'                            => __('\'Set password\' button style', 'wpamelia'),
            'csb_cust_profile'                                => __('Profile', 'wpamelia'),
            'csb_cust_profile_content'                        => __('Field order, mandatory fields, labels and display options', 'wpamelia'),
            'csb_cust_appointments'                           => __('Appointments', 'wpamelia'),
            'csb_cust_appointments_content'                   => __('Set up visibility, button type and labels', 'wpamelia'),
            'csb_cust_events'                                 => __('Events', 'wpamelia'),
            'csb_cust_events_content'                         => __('Set up visibility, button type and labels', 'wpamelia'),
            'csb_cust_packages_list'                          => __('Packages', 'wpamelia'),
            'csb_cust_packages_list_content'                  => __('Set up visibility, button type and labels', 'wpamelia'),
            'csb_cust_package_appointments'                   => __('Packages appointments', 'wpamelia'),
            'csb_cust_package_appointments_content'           => __('Set up display options and labels', 'wpamelia'),
            'csb_cust_filter_service'                         => __('Service filter', 'wpamelia'),
            'csb_cust_filter_employee'                        => __('Employee filter', 'wpamelia'),
            'csb_cust_filter_customer'                        => __('Customer filter', 'wpamelia'),
            'csb_cust_filter_location'                        => __('Location filter', 'wpamelia'),
            'csb_cust_filter_packages'                        => __('Package filter', 'wpamelia'),
            'csb_cust_filter_event'                           => __('Event filter', 'wpamelia'),
            'csb_cust_appointment_employee'                   => __('Employee', 'wpamelia'),
            'csb_cust_appointment_customer'                   => __('Customer', 'wpamelia'),
            'csb_cust_appointment_customer_phone'             => __('Customer phone', 'wpamelia'),
            'csb_cust_appointment_customer_email'             => __('Customer email', 'wpamelia'),
            'csb_cust_appointment_price'                      => __('Price', 'wpamelia'),
            'csb_cust_event_employee'                         => __('Employees', 'wpamelia'),
            'csb_cust_event_customer'                         => __('Customer', 'wpamelia'),
            'csb_cust_event_customer_phone'                   => __('Customer phone', 'wpamelia'),
            'csb_cust_event_customer_email'                   => __('Customer email', 'wpamelia'),
            'csb_cust_event_price'                            => __('Price', 'wpamelia'),
            'csb_cust_sign_in'                                => __('Sign in', 'wpamelia'),
            'csb_cust_sign_in_content'                        => __('Set up button type and labels', 'wpamelia'),
            'csb_cust_access_link'                            => __('Access link', 'wpamelia'),
            'csb_cust_access_link_content'                    => __('Set up button type and labels', 'wpamelia'),
            'csb_cust_access_link_success'                    => __('Access link success', 'wpamelia'),
            'csb_cust_access_link_success_content'            => __('Set up labels', 'wpamelia'),
            'csb_cust_set_new_pass'                           => __('Set new password', 'wpamelia'),
            'csb_cust_set_new_pass_content'                   => __('Set up button type and labels', 'wpamelia'),
            'date_of_birth'                                   => __('Date of birth', 'wpamelia'),
            'enter_date_of_birth'                             => __('Enter date of birth', 'wpamelia'),
            'enter_date_of_birth_warning'                     => __('Please enter date of birth', 'wpamelia'),
            'new_password_set'                                => __('Set password', 'wpamelia'),
            'new_password_set_action'                         => __('Set password', 'wpamelia'),
            'new_password_set_description'                    => __('Enter, and re-enter your new password to continue', 'wpamelia'),
            'new_password_colon'                              => __('New password', 'wpamelia'),
            'new_password_required'                           => __('Please enter new password', 'wpamelia'),
            'new_password_length'                             => __('Password must be longer than 3 characters', 'wpamelia'),
            'new_password_changed'                            => __('Password Updated!', 'wpamelia'),
            'new_password_changed_description'                => __('Your password has been changed successfully. Use your new password to log in.', 'wpamelia'),
            'passwords_not_match'                             => __('Passwords do not match', 'wpamelia'),
            'delete_profile'                                  => __('Delete profile', 'wpamelia'),
            'delete_profile_confirm'                          => __('Delete profile', 'wpamelia'),
            'delete_profile_description'                      => __('Are you sure you want to delete your profile? You will lose access to all your bookings and access to the customer panel.', 'wpamelia'),
            'save_changes'                                    => __('Save changes', 'wpamelia'),
            'change_password'                                 => __('Change password', 'wpamelia'),
            'no_app_found'                                    => __('No appointments found', 'wpamelia'),
            'have_no_app'                                     => __('You don\'t have any appointments', 'wpamelia'),
            'no_pack_found'                                   => __('No packages found', 'wpamelia'),
            'have_no_pack'                                    => __('You don\'t have any packages', 'wpamelia'),
            'no_evt_found'                                    => __('No events found', 'wpamelia'),
            'have_no_evt'                                     => __('You don\'t have any events', 'wpamelia'),
            'cust_empty_state'                                => __('Empty state', 'wpamelia'),
            'step_tickets_tab'                                => __('Step tickets tab', 'wpamelia'),
            'coupon_segment'                                  => __('Coupon segment', 'wpamelia'),
            'waiting_background'                              => __('Waiting button background color', 'wpamelia'),
            'waiting_text'                                    => __('Waiting button text color', 'wpamelia'),
            'csb_events_calendar_content'                     => __('Set up Location, Images, Filters, Capacity, Price, and Status visibility options', 'wpamelia'),
            'join_waiting_list'                               => __('Join waiting list', 'wpamelia'),
            'people_waiting'                                  => __('people waiting', 'wpamelia'),
            'person_waiting'                                  => __('person waiting', 'wpamelia'),
            'waiting_list'                                    => __('Waiting list', 'wpamelia'),
            'upcoming'                                        => __('Upcoming', 'wpamelia'),
            'waiting'                                         => __('Waiting', 'wpamelia'),
            'booking_waiting_btn'                             => __('\'Join waiting list\' button style', 'wpamelia'),
            'your_position_on_waiting_list'                   => __('You are on the waiting list with position', 'wpamelia'),
            'waiting_list_notify_message'                     => __('We\'ll notify you if a spot opens up and your booking is approved.', 'wpamelia'),
            'event_add_attendee'                              => __('Add Attendee', 'wpamelia'),
            'new_appointment'                                 => __('New appointment', 'wpamelia'),
            'new_event'                                       => __('New Event', 'wpamelia'),
            'new_app_button_type'                             => __('\'New appointment\' button style', 'wpamelia'),
            'new_evt_button_type'                             => __('\'New Event\' button style', 'wpamelia'),
            'qr_etickets_evt_button'                          => __('\'Scan e-ticket\' button', 'wpamelia'),
            'view_in_package'                                 => __('View in Package', 'wpamelia'),
            'view_in_package_buttons'                         => __('\'View in package\' button', 'wpamelia'),
            'notice_panel'                                    => __('Notice: Please select at least one panel.', 'wpamelia'),
            'search_date'                                     => __('Preselect Current Date', 'wpamelia'),
            'search_divi'                                     => __('AM - Search view', 'wpamelia'),
            'customer_cabinet_divi'                           => __('AM - Customer Panel', 'wpamelia'),
            'employee_cabinet_divi'                           => __('AM - Employee Panel', 'wpamelia'),
            'search_gutenberg_block'                          => [
                'title'       => __('Amelia - Search view', 'wpamelia'),
                'description' => __('Front-end Booking Search is shortcode that give your customers the possibility to search for appointment by selecting several filters so that they could find the best time slots and services for their needs.', 'wpamelia'),
            ],
            'customer_cabinet_gutenberg_block'                => [
                'title'       => __('Amelia - Customer Panel', 'wpamelia'),
                'description' => __('Front-end Customer Panel is a shortcode that gives your customers the possibility to manage their bookings and profile information.', 'wpamelia'),
            ],
            'employee_cabinet_gutenberg_block'                => [
                'title'       => __('Amelia - Employee Panel', 'wpamelia'),
                'description' => __('Front-end Employee Panel is a shortcode that gives your employees the possibility to manage their bookings, working hours, days off, assigned services and profile information.', 'wpamelia'),
            ],
            'amelia_settings_profile'                         => __('Amelia Profile Settings', 'wpamelia'),
            'amelia_settings_customers'                       => __('Amelia Users Settings', 'wpamelia'),
            'enable_amelia'                                   => __('Enable Amelia', 'wpamelia'),
            'enable_booking_tab'                              => __('Enable Amelia Tabs on Profiles', 'wpamelia'),
            'booking_form_enabled'                            => __('Booking form on customer profile enabled', 'wpamelia'),
            'bookingform_enabled'                             => __('Booking form tab enabled', 'wpamelia'),
            'booking_form_employee_enabled'                   => __('Booking form on employee profile enabled', 'wpamelia'),
            'booking_form_type'                               => __('Booking form type', 'wpamelia'),
            'booking_form_type_employee'                      => __('Booking form type on employee profile page', 'wpamelia'),
            'booking_tab_name'                                => __('Booking tab name', 'wpamelia'),
            'book_subtab_name'                                => __('Book subtab name', 'wpamelia'),
            'panel_subtab_name'                               => __('Panel subtab name', 'wpamelia'),
            'booking_employee_tab_name'                       => __('Booking on employee page tab name', 'wpamelia'),
            'booking_form_events_list'                        => __('Events List', 'wpamelia'),
            'booking_form_events_calendar'                    => __('Events Calendar', 'wpamelia'),
            'subscribers_transform'                           => __('Automatically create Amelia Customers from WP Users ', 'wpamelia'),
            'subscribers_transform_text'                      => __('After account activation, subscribers will be created as customers in Amelia ', 'wpamelia'),
            'create_providers_text'                           => __('Create Employees from WP Users with Amelia Employee Role', 'wpamelia'),
            'create_providers'                                => __('Create Amelia Employees', 'wpamelia'),
            'create_customers'                                => __('Create Amelia Customers', 'wpamelia'),
            'create_customers_text'                           => __('Create Customers from WP Users with Amelia Customer Role', 'wpamelia'),
            'guest_booking_enabled'                           => __('Enable guest booking', 'wpamelia'),
            'guest_booking_enabled_text'                      => __('Allow booking without a prior login', 'wpamelia'),
            'recurring_sub_message2'                          => __('Number of adjusted time slots: ', 'wpamelia'),
            'recurring_until'                                 => __('Until', 'wpamelia'),
            'recurring_every_text'                            => __('Every', 'wpamelia'),
            'recurring_date_specific'                         => __('Specific Date', 'wpamelia'),
            'recurring_date_first'                            => __('First', 'wpamelia'),
            'recurring_date_second'                           => __('Second', 'wpamelia'),
            'recurring_date_third'                            => __('Third', 'wpamelia'),
            'recurring_date_fourth'                           => __('Fourth', 'wpamelia'),
            'recurring_date_last'                             => __('Last', 'wpamelia'),
            'red_all_customers'                               => __('All customers', 'wpamelia'),
            'red_apply_booking_close_to_recurring_events'     => __("Apply 'Booking close' settings to all recurring events", 'wpamelia'),
            'red_apply_booking_open_to_recurring_events'      => __("Apply 'Booking open' settings to all recurring events", 'wpamelia'),
            'red_apply_changes_to_events_subtitle'            => __("You're editing a recurring event. Apply changes only to this one, or to this and all future events? Note: Tickets for events with attendees will not be updated.", 'wpamelia'),
            'red_apply_changes_to_events'                     => __('Apply Changes to Events', 'wpamelia'),
            'red_apply_to_future_recurring_events'            => __('Apply to future recurring events', 'wpamelia'),
            'red_apply'                                       => __('Apply', 'wpamelia'),
            'red_appointment_count'                           => __('{count} Appointment | {count} Appointments', 'wpamelia'),
            'red_appointment_not_found'                       => __('Appointment not found.', 'wpamelia'),
            'red_appointment_note'                            => __('Appointment note', 'wpamelia'),
            'red_appointment_updated_success'                 => __('Appointment has been updated.', 'wpamelia'),
            'red_appointment_x_count'                         => __('{count}x Appointment | {count}x Appointments', 'wpamelia'),
            'red_backend'                                     => __('Backend', 'wpamelia'),
            'red_booked_booked_total'                         => __('{booked}/{total} Booked', 'wpamelia'),
            'red_buffer_time_after_with_value'                => __('Buffer Time After: {value}', 'wpamelia'),
            'red_buffer_time_before_with_value'               => __('Buffer Time Before: {value}', 'wpamelia'),
            'red_collapse_all'                                => __('Collapse all', 'wpamelia'),
            'red_count_assigned'                              => __('{count} Assigned', 'wpamelia'),
            'red_count_employees'                             => __('{count} Employees', 'wpamelia'),
            'red_count_extras'                                => __('{count} Extras', 'wpamelia'),
            'red_count_once'                                  => __('Count Once', 'wpamelia'),
            'red_count_per_person'                            => __('Count per Person', 'wpamelia'),
            'red_count_spots'                                 => __('{count} Spots', 'wpamelia'),
            'red_count_total'                                 => __('{count} Total', 'wpamelia'),
            'red_custom_duration_pricing_tooltip'             => __('Offer multiple durations and prices for this service.', 'wpamelia'),
            'red_custom_persons_pricing_tooltip'              => __('Set pricing based on the number of people in the booking.', 'wpamelia'),
            'red_custom_periods_pricing_tooltip'              => __('Set different prices for specific days, times, or custom dates.', 'wpamelia'),
            'red_custom_fields_delivery_tooltip'              => __('Choose how custom field data is sent in group bookings.', 'wpamelia'),
            'red_custom_fields_delivery'                      => __('Custom fields delivery', 'wpamelia'),
            'red_customer_conflict_email'                     => __('{count} customers with the same email address already exist in your customer list. If you choose to overwrite these records, some of their current data will be replaced with new information.', 'wpamelia'),
            'red_customer_not_imported'                       => __('{count} customers were not imported due to missing First Name, Last Name, invalid Email, Phone number, or a combination of these reasons.', 'wpamelia'),
            'red_customer_note_success'                       => __('Customer note has been added.', 'wpamelia'),
            'red_repeat'                                      => __('Repeat', 'wpamelia'),
            'red_data_that_remains_unchanged'                 => __('Data that remains unchanged:', 'wpamelia'),
            'red_data_to_be_updated'                          => __('Data to be updated:', 'wpamelia'),
            'red_date_purchased_asc'                          => __('Date Purchased Asc', 'wpamelia'),
            'red_date_purchased_desc'                         => __('Date Purchased Desc', 'wpamelia'),
            'red_day_count'                                   => __('{count} Day | {count} Days', 'wpamelia'),
            'red_deduction_asc'                               => __('Deduction Asc', 'wpamelia'),
            'red_deduction_desc'                              => __('Deduction Desc', 'wpamelia'),
            'red_delete_category_effect_package'              => __('Could not delete category. This category has services available for booking in purchased package.', 'wpamelia'),
            'red_delete_custom_field_subtitle'                => __('Are you sure? This action can\'t be undone.', 'wpamelia'),
            'red_delete_custom_field'                         => __('Delete custom field', 'wpamelia'),
            'red_delete_location_effect'                      => __('This location has {count} service connected to it. | This location has {count} services connected to it.', 'wpamelia'),
            'red_delete_package_booking_subtitle'             => __('Are you sure you want to delete this package booking?', 'wpamelia'),
            'red_delete_package_booking'                      => __('Delete Package Booking', 'wpamelia'),
            'red_delete_package_effect_future'                => __('This package has {count} appointment in the future. | This package has {count} appointments in the future.', 'wpamelia'),
            'red_delete_package_effect_past'                  => __('This package has {count} appointment in the past. | This package has {count} appointments in the past.', 'wpamelia'),
            'red_delete_service_effect_package'               => __('This service is available for booking in purchased package. Are you sure you want to delete this service?', 'wpamelia'),
            'red_delete_user_effect_package'                  => __('This user has bookings in purchased package.. Are you sure you want to delete this user?', 'wpamelia'),
            'red_deposit_payment_tooltip'                     => __('Enable to require a deposit payment.', 'wpamelia'),
            'red_discount_asc'                                => __('Discount Asc', 'wpamelia'),
            'red_discount_desc'                               => __('Discount Desc', 'wpamelia'),
            'red_duplicate_fields'                            => __('Duplicate fields are not allowed.', 'wpamelia'),
            'red_edit_extra'                                  => __('Edit Extra', 'wpamelia'),
            'red_edit_package_booking'                        => __('Edit Package Booking', 'wpamelia'),
            'red_expand_all'                                  => __('Expand all', 'wpamelia'),
            'red_extras_included_in_deposit'                  => __('Extras are included in the deposit amount.', 'wpamelia'),
            'red_extras_not_included_in_deposit'              => __('Extras are not included in the deposit amount.', 'wpamelia'),
            'red_failed_to_load_appointment_details'          => __('Failed to load appointment details. Please try again later.', 'wpamelia'),
            'red_failed_to_load_package_details'              => __('Failed to load package details. Please try again later.', 'wpamelia'),
            'red_filter'                                      => __('Filter', 'wpamelia'),
            'red_frontend_and_backend'                        => __('Frontend & Backend', 'wpamelia'),
            'red_frontend'                                    => __('Frontend', 'wpamelia'),
            'red_group_booking'                               => __('Group booking', 'wpamelia'),
            'red_import_successful_description'               => __('{successfulImports} out of {totalRows} customers have been imported to your customer list.', 'wpamelia'),
            'red_join'                                        => __('Join', 'wpamelia'),
            'red_keep_individual'                             => __('Keep Individual', 'wpamelia'),
            'red_location_added_success'                      => __('Location has been added.', 'wpamelia'),
            'red_location_details'                            => __('Location details', 'wpamelia'),
            'red_location_updated_success'                    => __('Location has been updated.', 'wpamelia'),
            'red_mandatory_extra_tooltip'                     => __('Enable this option if you want customers to select at least one extra when booking. You can also choose how many extras are required.', 'wpamelia'),
            'red_max'                                         => __('Max', 'wpamelia'),
            'red_missing_required_fields'                     => __('Missing required fields:', 'wpamelia'),
            'red_month_count'                                 => __('{count} Month | {count} Months', 'wpamelia'),
            'red_multiple'                                    => __('Multiple', 'wpamelia'),
            'red_new_package_booking'                         => __('New package booking', 'wpamelia'),
            'red_new_space'                                   => __('New Space', 'wpamelia'),
            'red_no_booked_appointments_subtitle'             => __('There are no booked appointments for this package.', 'wpamelia'),
            'red_no_booked_appointments'                      => __('No booked appointments', 'wpamelia'),
            'red_no_bookings_found'                           => __('No bookings found', 'wpamelia'),
            'red_no_coupons_subtitle_1'                       => __('Once you add your first Coupon, it will appear here. Click + Coupon above to get started.', 'wpamelia'),
            'red_no_coupons_title'                            => __('No coupons yet', 'wpamelia'),
            'red_no_custom_fields_yet_subtitle'               => __('Once you add your first custom field, it will appear here. Click + Custom Field below to get started.', 'wpamelia'),
            'red_no_custom_fields_yet'                        => __('No custom fields yet', 'wpamelia'),
            'red_no_customers_imported'                       => __('No customers were imported to your customer list.', 'wpamelia'),
            'red_no_employees_assigned_to_this_location'      => __('No Employees Assigned to This Location', 'wpamelia'),
            'red_no_extras_subtitle_1'                        => __('Once you add your first extra, it will appear here. Click + Extra above to get started.', 'wpamelia'),
            'red_no_extras_yet'                               => __('No extras yet', 'wpamelia'),
            'red_no_locations_subtitle_1'                     => __('Once you start adding locations, they will appear here. You can also get started by clicking the Add button below.', 'wpamelia'),
            'red_no_locations_title'                          => __('No locations yet', 'wpamelia'),
            'red_no_package_bookings_subtitle_1'              => __('Once you receive package bookings, they will be displayed here. You can also get started by clicking the Book Package button below.', 'wpamelia'),
            'red_no_package_bookings_yet'                     => __('No package bookings yet', 'wpamelia'),
            'red_no_packages_subtitle_1'                      => __('Once you add your first package, it will appear here. Click + Package below to get started.', 'wpamelia'),
            'red_no_packages_subtitle'                        => __('There are no packages. Please create a new package.', 'wpamelia'),
            'red_no_packages_yet'                             => __('No packages yet', 'wpamelia'),
            'red_no_packages'                                 => __('No Packages', 'wpamelia'),
            'red_no_resources_subtitle_1'                     => __('Once you add your first resource, it will appear here. Click + Resource below to get started.', 'wpamelia'),
            'red_no_resources_yet'                            => __('No resources yet', 'wpamelia'),
            'red_no_show'                                     => __('No Show', 'wpamelia'),
            'red_option_number'                               => __('Option {number}', 'wpamelia'),
            'red_package_added_success'                       => __('Package has been created.', 'wpamelia'),
            'red_package_asc'                                 => __('Package Asc', 'wpamelia'),
            'red_package_booking_created_success'             => __('Package booking has been created.', 'wpamelia'),
            'red_package_booking_updated_success'             => __('Package booking has been updated.', 'wpamelia'),
            'red_package_booking_details'                     => __('Package booking details', 'wpamelia'),
            'red_package_booking_is_not_available'            => __('Package booking is not available for this time slot.', 'wpamelia'),
            'red_package_desc'                                => __('Package Desc', 'wpamelia'),
            'red_package_price'                               => __('Package price:', 'wpamelia'),
            'red_package_updated_success'                     => __('Package has been updated.', 'wpamelia'),
            'red_packages_reordered_failed'                   => __('Failed to reorder packages.', 'wpamelia'),
            'red_packages_reordered_successfully'             => __('Packages have been reordered.', 'wpamelia'),
            'red_per_customer'                                => __('Per customer', 'wpamelia'),
            'red_per_location_tooltip'                        => __('The resource quantity is counted separately for each selected location.', 'wpamelia'),
            'red_per_location'                                => __('Per Location', 'wpamelia'),
            'red_per_service_tooltip'                         => __('The resource quantity is counted separately for each selected service.', 'wpamelia'),
            'red_per_service'                                 => __('Per Service', 'wpamelia'),
            'red_please_select_date_range_inside_period'      => __('Please select a date range that is within the period range.', 'wpamelia'),
            'red_price_type'                                  => __('Price type', 'wpamelia'),
            'red_quantity_asc'                                => __('Quantity Asc', 'wpamelia'),
            'red_quantity_desc'                               => __('Quantity Desc', 'wpamelia'),
            'red_reorder_packages_description'                => __('Reordering packages affects how they are displayed on the website.', 'wpamelia'),
            'red_reorder_packages'                            => __('Reorder Packages', 'wpamelia'),
            'red_reschedule_time_slot_not_available'          => __('The time slot you tried to reschedule to is not available. Please select a different time slot for the selected date.', 'wpamelia'),
            'red_resource_added_success'                      => __('Resource has been added.', 'wpamelia'),
            'red_tax_added_success'                           => __('Tax has been added.', 'wpamelia'),
            'red_tax_updated_success'                         => __('Tax has been updated.', 'wpamelia'),
            'red_coupon_added_success'                        => __('Coupon has been created.', 'wpamelia'),
            'red_coupon_updated_success'                      => __('Coupon has been updated.', 'wpamelia'),
            'red_resource_details'                            => __('Resource Details', 'wpamelia'),
            'red_resource_per_location'                       => __('Quantity per location', 'wpamelia'),
            'red_resource_per_service'                        => __('Quantity per service', 'wpamelia'),
            'red_resource_updated_success'                    => __('Resource has been updated.', 'wpamelia'),
            'red_search_booked_appointments'                  => __('Search booked appointments', 'wpamelia'),
            'red_search_extras'                               => __('Search extras', 'wpamelia'),
            'red_select_end_date_warning'                     => __('Please select an end date.', 'wpamelia'),
            'red_select_package_warning'                      => __('Please select a package.', 'wpamelia'),
            'red_server_error'                                => __('A server error occurred. Please try again later.', 'wpamelia'),
            'red_service_count'                               => __('{count} Service | {count} Services', 'wpamelia'),
            'red_service_recurring_sub_disabled'              => __('Don\'t suggest alternatives', 'wpamelia'),
            'red_services_asc'                                => __('Services Asc', 'wpamelia'),
            'red_services_desc'                               => __('Services Desc', 'wpamelia'),
            'red_shared_capacity'                             => __('Shared capacity across services', 'wpamelia'),
            'red_shared_pool'                                 => __('Shared Pool', 'wpamelia'),
            'red_show_on'                                     => __('Visible at', 'wpamelia'),
            'red_start'                                       => __('Start', 'wpamelia'),
            'red_this_and_future'                             => __('This & Future', 'wpamelia'),
            'red_this_only'                                   => __('This Only', 'wpamelia'),
            'red_time_slot_unavailable'                       => __('This time slot is no longer available. Please select a different time.', 'wpamelia'),
            'red_time_used_asc'                               => __('Time Used Asc', 'wpamelia'),
            'red_time_used_desc'                              => __('Time Used Desc', 'wpamelia'),
            'red_tip_location_wp_hooks'                       => __('Location WP Hooks', 'wpamelia'),
            'red_tip_locations_setup'                         => __('Locations setup', 'wpamelia'),
            'red_tip_managing_packages'                       => __('Managing packages', 'wpamelia'),
            'red_tip_package_management'                      => __('Package management', 'wpamelia'),
            'red_tip_packages_overview'                       => __('Packages overview', 'wpamelia'),
            'red_tip_resource_booking_setup'                  => __('Resource booking setup', 'wpamelia'),
            'red_webhooks_setup'                              => __('Webhooks setup', 'wpamelia'),
            'red_tip_service_packages_overview'               => __('Service packages overview', 'wpamelia'),
            'red_tip_outlook_calendar_setup'                  => __('Outlook Calendar setup', 'wpamelia'),
            'red_tip_ms_teams_setup'                          => __('Microsoft Teams setup', 'wpamelia'),
            'red_tip_whatsapp_setup'                          => __('WhatsApp setup', 'wpamelia'),
            'red_total_number_of_appointments'                => __('Total number of appointments', 'wpamelia'),
            'red_unexpected_error'                            => __('An unexpected error occurred. Please try again later.', 'wpamelia'),
            'red_view_packages'                               => __('View packages', 'wpamelia'),
            'red_week_count'                                  => __('{count} Week | {count} Weeks', 'wpamelia'),
            'red_discount_type'                               => __('Discount type', 'wpamelia'),
            'red_percentage_amount'                           => __('Percentage amount', 'wpamelia'),
            'red_no_usage_limit'                              => __('No usage limit', 'wpamelia'),
            'red_no_limit_per_customer'                       => __('No limit per customer', 'wpamelia'),
            'red_tip_coupons_overview'                        => __('Coupons overview', 'wpamelia'),
            'red_coupon_details'                              => __('Coupon Details', 'wpamelia'),
            'red_limit_per_customer'                          => __('Limit per customer', 'wpamelia'),
            'red_usage'                                       => __('Usage', 'wpamelia'),
            'red_invoice_number_asc'                          => __('Invoice Number Asc', 'wpamelia'),
            'red_invoice_number_desc'                         => __('Invoice Number Desc', 'wpamelia'),
            'red_no_invoices_title'                           => __('No invoices yet', 'wpamelia'),
            'red_no_invoices_subtitle_1'                      => __('Once you start receiving bookings, invoices will be displayed here.', 'wpamelia'),
            'red_invoice_number_count'                        => __('Invoice #{count}', 'wpamelia'),
            'red_invoice_date'                                => __('Invoice date', 'wpamelia'),
            'red_refund_transaction'                          => __('Refund Transaction', 'wpamelia'),
            'red_type_asc'                                    => __('Type Asc', 'wpamelia'),
            'red_type_desc'                                   => __('Type Desc', 'wpamelia'),
            'red_no_taxes_subtitle_1'                         => __('Once you add your first tax, it will appear here. Click + Tax below to get started.', 'wpamelia'),
            'red_no_taxes_title'                              => __('No taxes yet', 'wpamelia'),
            'red_tip_taxes_overview'                          => __('Taxes overview', 'wpamelia'),
            'red_tax_rate_name'                               => __('Tax rate name', 'wpamelia'),
            'red_please_enter_tax_rate_name'                  => __('Please enter tax rate name.', 'wpamelia'),
            'red_please_enter_tax_amount'                     => __('Please enter a tax amount.', 'wpamelia'),
            'red_tax_details'                                 => __('Tax details', 'wpamelia'),
            'red_fixed'                                       => __('Fixed', 'wpamelia'),
            'red_badge'                                       => __('Badge', 'wpamelia'),
            'red_role'                                        => __('Role', 'wpamelia'),
            'red_employee_zoom_description'                   => __('Connect your personal Zoom account to host virtual meetings and chats.', 'wpamelia'),
            'red_employee_zoom_not_available_description'     => __('Connecting to Zoom is not available. Please contact an administrator for assistance.', 'wpamelia'),
            'red_employee_google_description'                 => __('Sync your schedule with your personal Google Calendar to prevent double bookings.', 'wpamelia'),
            'red_employee_google_calendar_connected_by_admin' => __('You are currently connected to Google Calendar by Admin. Overriding Google Calendar connection is not available.', 'wpamelia'),
            'red_employee_google_not_available_description'   => __('Connecting to Google Calendar is not available. Please contact an administrator for assistance.', 'wpamelia'),
            'red_employee_outlook_description'                => __('Sync your schedule with your personal Outlook Calendar to prevent double bookings.', 'wpamelia'),
            'red_employee_outlook_not_available_description'  => __('Connecting to Outlook Calendar is not available. Please contact an administrator for assistance.', 'wpamelia'),
            'red_employee_apple_description'                  => __('Sync your schedule with your personal Apple Calendar to prevent double bookings.', 'wpamelia'),
            'red_employee_apple_not_available_description'    => __('Connecting to Apple Calendar is not available. Please contact an administrator for assistance.', 'wpamelia'),
            'red_employee_stripe_description'                 => __('Sync your Stripe Connect account for effortless payments and seamless payouts.', 'wpamelia'),
            'red_employee_stripe_not_available_description'   => __('Connecting to Stripe is not available. Please contact an administrator for assistance.', 'wpamelia'),
            'red_connected'                                   => __('Connected', 'wpamelia'),
            'red_not_connected'                               => __('Not connected', 'wpamelia'),
            'red_not_available'                               => __('Not available', 'wpamelia'),
            'red_sync_with'                                   => __('Sync with', 'wpamelia'),
            'red_upcoming_appointments_warning'               => __('There are upcoming appointments for the {service} service.', 'wpamelia'),
            'red_only_provider_warning'                       => __('This employee is the only one assigned to {service}.', 'wpamelia'),
            'red_edit_special_day'                            => __('Edit special day', 'wpamelia'),
            'red_stripe_connect'                              => __('Stripe Connect', 'wpamelia'),
            'red_recurring_times'                             => __('Times', 'wpamelia'),
            'red_first_day'                                   => __('First {day}', 'wpamelia'),
            'red_second_day'                                  => __('Second {day}', 'wpamelia'),
            'red_third_day'                                   => __('Third {day}', 'wpamelia'),
            'red_fourth_day'                                  => __('Fourth {day}', 'wpamelia'),
            'red_recurring_alert_setup_description_1'         => __('The proposed date and time are different from your selected pattern due to unavailable time slots on the expected date and time.', 'wpamelia'),
            'red_recurring_alert_setup_description_2'         => __('The proposed date is different from your selected pattern due to unavailable time slots on the expected date.', 'wpamelia'),
            'red_recurring_alert_setup_description_3'         => __('The proposed time is different from your selected pattern due to unavailable time slots at the expected time.', 'wpamelia'),
            'red_oliver'                                      => __('Oliver', 'wpamelia'),
            'red_unique_service'                              => __('Unique (Service)', 'wpamelia'),
            'red_unique_location'                             => __('Unique (Location)', 'wpamelia'),
            'red_shared'                                      => __('Shared', 'wpamelia'),
            'red_buffer_time'                                 => __('Buffer Time', 'wpamelia'),
            'red_phone_copied_to_clipboard'                   => __('Phone number copied to clipboard.', 'wpamelia'),
            'red_email_copied_to_clipboard'                   => __('Email copied to clipboard.', 'wpamelia'),
            'red_link_copied_to_clipboard'                    => __('Link copied to clipboard.', 'wpamelia'),
            'red_placeholder_copied_to_clipboard'             => __('Placeholder copied to clipboard.', 'wpamelia'),
            'red_payment_currency'                            => __('Payment currency', 'wpamelia'),
            'red_package_id'                                  => __('Package ID', 'wpamelia'),
            'red_delete_coupon'                               => __('Delete coupon', 'wpamelia'),
            'red_delete_event_booking'                        => __('Delete event booking', 'wpamelia'),
            'red_delete_location'                             => __('Delete location', 'wpamelia'),
            'red_delete_package'                              => __('Delete package', 'wpamelia'),
            'red_delete_resource'                             => __('Delete resource', 'wpamelia'),
            'red_delete_tax'                                  => __('Delete tax', 'wpamelia'),
            'red_hide_location'                               => __('Hide location', 'wpamelia'),
            'red_hide_package'                                => __('Hide package', 'wpamelia'),
            'red_hide_resource'                               => __('Hide resource', 'wpamelia'),
            'red_hide_coupon'                                 => __('Hide coupon', 'wpamelia'),
            'red_hide_tax'                                    => __('Hide tax', 'wpamelia'),
            'red_show_location'                               => __('Show location', 'wpamelia'),
            'red_show_package'                                => __('Show package', 'wpamelia'),
            'red_show_resource'                               => __('Show resource', 'wpamelia'),
            'red_show_service'                                => __('Show service', 'wpamelia'),
            'red_show_coupon'                                 => __('Show coupon', 'wpamelia'),
            'red_show_tax'                                    => __('Show tax', 'wpamelia'),
            'red_duplicate_coupon'                            => __('Duplicate coupon', 'wpamelia'),
            'red_duplicate_employee'                          => __('Duplicate employee', 'wpamelia'),
            'red_duplicate_location'                          => __('Duplicate location', 'wpamelia'),
            'red_duplicate_package'                           => __('Duplicate package', 'wpamelia'),
            'red_duplicate_resource'                          => __('Duplicate resource', 'wpamelia'),
            'red_app_max_capacity_warning'                    => __('The total number of persons ({approvedPersonsCount}) exceeds the maximum capacity of {maxAppointmentCapacity}.', 'wpamelia'),
            'red_app_waiting_list_max_capacity_warning'       => __('The total number of persons ({waitingPersonsCount}) exceeds the maximum waiting list capacity of {waitingListMaxCapacity}.', 'wpamelia'),
            'red_custom_fields_updated_success'               => __('Custom fields have been updated.', 'wpamelia'),
            'red_count_more'                                  => __('+{count} more', 'wpamelia'),
            'red_package_booking_deleted'                     => __('Package booking has been deleted.', 'wpamelia'),
            'red_count_resources_deleted'                     => __('{count} resource has been deleted. | {count} resources have been deleted.', 'wpamelia'),
            'red_count_resources_failed_to_be_deleted'        => __('{count} resource has not been deleted. | {count} resources have not been deleted.', 'wpamelia'),
            'red_count_packages_deleted'                      => __('{count} package has been deleted. | {count} packages have been deleted.', 'wpamelia'),
            'red_count_packages_failed_to_be_deleted'         => __('{count} package has not been deleted due to future bookings. | {count} packages have not been deleted due to future bookings.', 'wpamelia'),
            'red_invoice_not_found'                           => __('Invoice not found.', 'wpamelia'),
            'red_count_package_bookings_deleted'              => __('{count} package booking has been deleted. | {count} package bookings have been deleted.', 'wpamelia'),
            'red_count_package_bookings_failed_to_be_deleted' => __('{count} package booking has not been deleted. | {count} package bookings have not been deleted.', 'wpamelia'),
            'red_package_appointment_updated'                 => __('Package appointment has been updated.', 'wpamelia'),
            'red_also_delete_future_events'                   => __('Also delete future events', 'wpamelia'),
            'red_also_cancel_and_delete_future_events'        => __('Also cancel and delete future events', 'wpamelia'),
            'red_also_cancel_and_delete_future_events_desc'   => __('You can also cancel and delete its future events.', 'wpamelia'),
            'red_also_cancel_future_events_desc'              => __('You can also cancel its future events.', 'wpamelia'),
            'red_also_open_future_events_desc'                => __('You can also open its future events.', 'wpamelia'),
            'red_also_delete_future_events_desc'              => __('You can also delete its future events.', 'wpamelia'),
            'red_also_cancel_future_events'                   => __('Also cancel future events', 'wpamelia'),
            'red_also_open_future_events'                     => __('Also open future events', 'wpamelia'),
            'red_count_taxes_deleted'                         => __('{count} tax has been deleted. | {count} taxes have been deleted.', 'wpamelia'),
            'red_count_taxes_failed_to_be_deleted'            => __('{count} tax has not been deleted. | {count} taxes have not been deleted.', 'wpamelia'),
            'red_count_coupons_deleted'                       => __('{count} coupon has been deleted. | {count} coupons have been deleted.', 'wpamelia'),
            'red_count_coupons_failed_to_be_deleted'          => __('{count} coupon has not been deleted. | {count} coupons have not been deleted.', 'wpamelia'),
            'red_count_employees_deleted'                     => __('{count} employee has been deleted. | {count} employees have been deleted.', 'wpamelia'),
            'red_count_employees_failed_to_be_deleted'        => __('{count} employee has not been deleted due to future bookings. | {count} employees have not been deleted due to future bookings.', 'wpamelia'),
            'red_count_locations_deleted'                     => __('{count} location has been deleted. | {count} locations have been deleted.', 'wpamelia'),
            'red_count_locations_failed_to_be_deleted'        => __('{count} location has not been deleted due to future bookings. | {count} locations have not been deleted due to future bookings.', 'wpamelia'),
            'red_new_language'                                => __('New language', 'wpamelia'),
            'red_group_bookings_export_format'                => __('Group booking export format', 'wpamelia'),
            'red_attendees_export_format'                     => __('Attendees Export Format', 'wpamelia'),
            'red_single_row_export'                           => __('Single-row export', 'wpamelia'),
            'red_separate_row_export'                         => __('Separate-row export', 'wpamelia'),
            'red_error_while_generating_csv'                  => __('Error while generating CSV.', 'wpamelia'),
            'red_count_items_selected'                        => __('{count} item selected | {count} items selected', 'wpamelia'),
            'red_count_events'                                => __('{count} event | {count} events', 'wpamelia'),
            'red_online_meetings'                             => __('Online meetings', 'wpamelia'),
            'red_show_all_periods'                            => __('Show All Periods', 'wpamelia'),
            'red_show_less_periods'                           => __('Show Less Periods', 'wpamelia'),
            'red_appointment_details'                         => __('Appointment details', 'wpamelia'),
            'red_booking_details'                             => __('Booking Details', 'wpamelia'),
            'red_on_site_payment'                             => __('On-site payment', 'wpamelia'),
            'red_host_link'                                   => __('Host link', 'wpamelia'),
            'red_join_link'                                   => __('Join link', 'wpamelia'),
            'red_invoice_number'                              => __('Invoice #', 'wpamelia'),
            'red_event_title_tooltip'                         => __('Set the title that will appear in the calendar event. You can use placeholders available on the Notifications page.', 'wpamelia'),
            'red_event_description_tooltip'                   => __('Set the description that will appear in the calendar event. You can use placeholders available on the Notifications page.', 'wpamelia'),
            'red_please_enter_event'                          => __('Please enter an event.', 'wpamelia'),
            'red_webhook'                                     => __('Webhook', 'wpamelia'),
            'red_edit_webhook'                                => __('Edit Webhook', 'wpamelia'),
            'red_add_webhook'                                 => __('Add Webhook', 'wpamelia'),
            'red_microsoft'                                   => __('Microsoft', 'wpamelia'),
            'red_how_to_get_your'                             => __('How to get your', 'wpamelia'),
            'red_outlook_application_secret'                  => __('application (client) ID and secret', 'wpamelia'),
            'red_include_buffer_time'                         => __('Include buffer time in calendar events', 'wpamelia'),
            'red_include_buffer_time_tooltip_apple'           => __('Enable this option to include buffer time for scheduled appointments in Apple Calendar events.', 'wpamelia'),
            'red_include_buffer_time_tooltip_google'          => __('Enable this option to include buffer time for scheduled appointments in Google Calendar events.', 'wpamelia'),
            'red_include_buffer_time_tooltip_outlook'         => __('Enable this option to include buffer time for scheduled appointments in Outlook Calendar events.', 'wpamelia'),
            'red_zoom_application_secret'                     => __('application ID, client ID and client secret', 'wpamelia'),
            'red_apple'                                       => __('Apple', 'wpamelia'),
            'red_tip_apple_calendar_setup'                    => __('Apple Calendar setup', 'wpamelia'),
            'red_apple_application_secret'                    => __('iCloud email address and iCloud app-specific password', 'wpamelia'),
            'red_google'                                      => __('Google', 'wpamelia'),
            'red_tip_google_calendar_setup'                   => __('Google Calendar setup', 'wpamelia'),
            'red_tip_google_analytics_setup'                  => __('Google Analytics setup', 'wpamelia'),
            'red_tip_social_login_setup'                      => __('Social login setup', 'wpamelia'),
            'red_google_application_secret'                   => __('Client ID and secret', 'wpamelia'),
            'red_edit_tracking'                               => __('Edit Tracking', 'wpamelia'),
            'red_tip_lesson_space_setup'                      => __('Lesson Space setup', 'wpamelia'),
            'red_tip_mailchimp_setup'                         => __('Mailchimp setup', 'wpamelia'),
            'red_meta'                                        => __('Meta', 'wpamelia'),
            'red_pixel_id'                                    => __('Pixel ID', 'wpamelia'),
            'red_tip_recaptcha_setup'                         => __('reCAPTCHA setup', 'wpamelia'),
            'red_tip_zoom_wp_hooks'                           => __('Zoom WP hooks', 'wpamelia'),
            'red_tip_facebook_pixel_setup'                    => __('Meta Pixel setup', 'wpamelia'),
            'red_tip_api_setup'                               => __('API setup', 'wpamelia'),
            'red_tip_outlook_calendar_wp_hooks'               => __('Outlook Calendar WP hooks', 'wpamelia'),
            'red_dont_send_reminders'                         => __('Don\'t send reminders within the selected time', 'wpamelia'),
            'red_dont_send_reminders_tooltip'                 => __('When enabled, reminders will not be sent if a booking is made within the selected time before the appointment or event.', 'wpamelia'),
            'red_combined_placeholders_alert'                 => __('This placeholder\'s content will be applied wherever it is used.', 'wpamelia'),
            'red_back_to'                                     => __('Back to', 'wpamelia'),
            'red_send_reset_link'                             => __('Send Reset Link', 'wpamelia'),
            'red_new_password'                                => __('New password', 'wpamelia'),
            'red_repeat_new_password'                         => __('Repeat new password', 'wpamelia'),
            'red_sms_history'                                 => __('SMS History', 'wpamelia'),
            'red_payment_history'                             => __('Payment History', 'wpamelia'),
            'red_auto_reply_message'                          => __('Auto-Reply Message', 'wpamelia'),
            'red_whatsapp_history'                            => __('WhatsApp history', 'wpamelia'),
            'red_whatsapp_settings'                           => __('WhatsApp settings', 'wpamelia'),
            'red_select_placeholder'                          => __('Select placeholder', 'wpamelia'),
            'red_whatsapp_empty_title'                        => __('WhatsApp Not Connected', 'wpamelia'),
            'red_whatsapp_empty_subtitle'                     => __('To use WhatsApp notifications, connect your WhatsApp account in Settings.', 'wpamelia'),
            'red_edit_custom_notification'                    => __('Edit custom notification', 'wpamelia'),
            'red_delete_notification'                         => __('Delete Notification', 'wpamelia'),
            'red_delete_notification_subtitle'                => __('Are you sure you want to delete this notification?', 'wpamelia'),
            'red_rules'                                       => __('Rules', 'wpamelia'),
            'red_manage_own_schedule'                         => __('Manage personal schedule', 'wpamelia'),
            'red_panel_access_permissions'                    => __('Panel & access permissions', 'wpamelia'),
            'red_waiting_list_capacity'                       => __('Waiting list capacity', 'wpamelia'),
            'red_recaptcha_customer_panel_enabled'            => __('reCAPTCHA on Customer Panel', 'wpamelia'),
            'red_recaptcha_provider_panel_enabled'            => __('reCAPTCHA on Employee Panel', 'wpamelia'),
            'red_scheduled_before_appointment'                => __('Scheduled Before Appointment', 'wpamelia'),
            'red_scheduled_before_event'                      => __('Scheduled Before Event', 'wpamelia'),
            'red_duplicate_event'                             => __('Duplicate Event', 'wpamelia'),
            'red_badges_setup'                                => __('Badges setup', 'wpamelia'),
            'red_coupons_setup'                               => __('Coupons setup', 'wpamelia'),
            'red_custom_fields_setup'                         => __('Custom fields setup', 'wpamelia'),
            'red_invoices_setup'                              => __('Invoices setup', 'wpamelia'),
            'red_tax_setup'                                   => __('Tax setup', 'wpamelia'),
            'red_event_close'                                 => __('Close Event', 'wpamelia'),
            'red_confirm_close'                               => __('Are you sure you want to close this event?', 'wpamelia'),
            'red_woo_tax'                                     => __('(+ Woo Tax)', 'wpamelia'),
            'red_sign_in_as'                                  => __('Sign in as ', 'wpamelia'),
            'red_scan'                                        => __('Scan', 'wpamelia'),
            'red_please_enter_ticket_code'                    => __('Please enter a ticket code.', 'wpamelia'),
            'red_enter_ticket_code_manually'                  => __('Enter ticket code manually', 'wpamelia'),
            'red_recaptcha_type'                              => __('reCAPTCHA Type', 'wpamelia'),
            'red_recaptcha_checkbox'                          => __('"I\'m not a robot" checkbox', 'wpamelia'),
            'red_recaptcha_invisible_badge'                   => __('Invisible reCAPTCHA badge', 'wpamelia'),
            'red_total_custom_fields'                         => __('Total custom fields', 'wpamelia'),
            'red_total_tickets'                               => __('Total tickets', 'wpamelia'),
            'red_total_extras'                                => __('Total extras', 'wpamelia'),
            'red_edit_custom_field'                           => __('Edit custom field', 'wpamelia'),
            'custom_font_family'                              => __('Custom font family', 'wpamelia'),
            'subscribe_to_mailing_list'                       => __('Subscribe to our mailing list', 'wpamelia'),
            'single_ticket'                                   => __('Single Ticket', 'wpamelia'),
            'group_ticket'                                    => __('Group Ticket', 'wpamelia'),
            'heading'                                         => __('Heading', 'wpamelia'),
            'e_tickets'                                       => __('E-Tickets', 'wpamelia'),
            'red_employee_outlook_calendar_connected_by_admin' => __('You are currently connected to Outlook Calendar by Admin. Overriding Outlook Calendar connection is not available.', 'wpamelia'),
        ];

        return array_merge(LiteBackendStrings::getAllStrings(), $labels);
    }
}
