<?php
/**
 * Vanity Coupon Codes: Assets Loader
 *
 * @package     AffiliateWP Vanity Coupon Codes
 * @subpackage  Display
 * @copyright   Copyright (c) 2021, Awesome Motive Inc
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.0
 */

namespace AffiliateWP_Vanity_Coupon_Codes\Display;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Assets class to load scripts and styles.
 *
 * @since 1.0
 *
 */
class Assets {
	/**
	 * Assets constructor.
	 *
	 * @since 1.0
	 */
	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'load_display_assets' ) );
	}
	
	/**
	 *  Load the display assets.
	 *
	 *  @since 1.0
	 *  @return void
	*/
	public function load_display_assets() {
		// Register.
		wp_register_style( 'vcc-display-style', AFFWP_VCC_PLUGIN_URL . 'assets/css/display.css', array(), AFFWP_VCC_VERSION );
		wp_register_script( 'vcc-affiliate-area-display', AFFWP_VCC_PLUGIN_URL . 'assets/js/affiliate-area-display.js', array( 'jquery' ), AFFWP_VCC_VERSION );
		wp_register_script( 'vcc-affiliate-portal-display', AFFWP_VCC_PLUGIN_URL . 'assets/js/affiliate-portal-display.js', array( 'jquery' ), AFFWP_VCC_VERSION );

		// Only load on the Affiliate Area Coupon tab.
		if ( 'coupons' === affwp_get_active_affiliate_area_tab() || isset( $_REQUEST['tab'] ) && 'coupons' === sanitize_key( $_REQUEST['tab'] ) ) {

			// Enqueue.
			affwp_enqueue_style( 'vcc-display-style', 'vanity-coupon-codes' );
			affwp_enqueue_script( 'vcc-affiliate-area-display', 'vanity-coupon-codes' );

			// Localize script with ajax url, edit link text, cancel link text, and default error.
			wp_localize_script(
				'vcc-affiliate-area-display',
				'affwp_vcc',
				array(
					'ajaxurl'      => admin_url( 'admin-ajax.php' ),
					'editLink'     => __( '(edit)', 'affiliatewp-vanity-coupon-codes' ),
					'cancelLink'   => __( '(cancel)', 'affiliatewp-vanity-coupon-codes' ),
					'defaultError' => __( 'Sorry, something went wrong.', 'affiliatewp-vanity-coupon-codes' ),
				),
			);
		}

		// Only load on the Affiliate Portal Coupon tab.
		if ( class_exists( 'AffiliateWP_Affiliate_Portal' ) && affwp_is_affiliate_portal( 'coupons' ) ) {

			// Enqueue.
			affwp_enqueue_script( 'vcc-affiliate-portal-display', 'vanity-coupon-codes' );

			// Localize script with ajax url, edit link text, cancel link text, and default error.
			wp_localize_script(
				'vcc-affiliate-portal-display',
				'affwp_vcc',
				array(
					'ajaxurl'      => admin_url( 'admin-ajax.php' ),
					'editLink'     => __( '(edit)', 'affiliatewp-vanity-coupon-codes' ),
					'cancelLink'   => __( '(cancel)', 'affiliatewp-vanity-coupon-codes' ),
					'defaultError' => __( 'Sorry, something went wrong.', 'affiliatewp-vanity-coupon-codes' ),
				),
			);
		}
	}
}
