<?php
/**
 * Vanity Coupon Codes Display: Affiliate Portal
 *
 * @package     AffiliateWP Vanity Coupon Codes
 * @subpackage  Display
 * @copyright   Copyright (c) 2021, Awesome Motive Inc
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.0
 */

namespace AffiliateWP_Vanity_Coupon_Codes\Display;
use AffiliateWP_Affiliate_Portal\Core\Components\Controls;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

require_once AFFWP_VCC_PLUGIN_DIR . 'includes/display/functions.php';

/**
 * Affiliate Portal Display class.
 *
 * @since 1.0
 *
 */
class Affiliate_Portal_Display {
	/**
	 * Affiliate Portal Display constructor.
	 *
	 * @since 1.0
	 */
	public function __construct() {
		add_action( 'affwp_portal_controls_registry_init', array( $this, 'affwp_vcc_register_replacement_code_column' ) );
	}

	/**
	 * Register the replacement coupon code column.
	 * Adds a form to request a vanity code and displays the submitted vanity code when pending review.
	 *
	 * @param \AffiliateWP_Affiliate_Portal\Core\Controls_Registry $registry
	 */
	public function affwp_vcc_register_replacement_code_column( $registry ) {

		$registry->add_control( new Controls\Table_Column_Control( array(
			'id'     => 'vanity-coupon-code',
			'parent' => 'coupons-table',
			'args'   => array(
				'replaces_column' => 'coupon_code',
				'title'           => 'Coupon Code',
				'render_callback' => function( $row, $table_control_id ) {
					return new Controls\Vanity_Coupon_Control( array(
						'id'   => "{$table_control_id}_vcc_coupon_ui",
						'args' => array(
							'coupon_data' => $row,
						),
					) );
				}
			)
		) ) );

	}

}