<?php
/**
 * Admin: View Payout View
 *
 * @package    AffiliateWP
 * @subpackage Admin/Payouts
 * @copyright  Copyright (c) 2016, Sandhills Development, LLC
 * @license    http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since      1.9
 */

$payout = affwp_get_payout( intval( $_GET['payout_id'] ) );
?>

<div class="wrap">

	<h2>
		<?php
		/* translators: Payout ID */
		printf( __( 'Payout: #%d', 'affiliate-wp' ), $payout->ID );
		?>
	</h2>

	<?php
	/**
	 * Fires at the top of the 'View Payout' page, just inside the opening div.
	 *
	 * @since 1.9
	 *
	 * @param \AffWP\Affiliate\Payout $payout Payout object.
	 */
	do_action( 'affwp_edit_payout_top', $payout );
	?>

	<table id="affwp_payout" class="form-table">

		<tr class="form-row">

			<th scope="row">
				<?php _e( 'Affiliate', 'affiliate-wp' ); ?>
			</th>

			<td>
				<?php
				$url = affwp_admin_url( 'affiliates', array(
					'action'       => 'view_affiliate',
					'affiliate_id' => $payout->affiliate_id
				) );

				$name      = affiliate_wp()->affiliates->get_affiliate_name( $payout->affiliate_id );
				$affiliate = affwp_get_affiliate( $payout->affiliate_id );

				printf( '<a href="%1$s">%2$s</a> (ID: %3$s)',
					esc_url( $url ),
					esc_html( $name ),
					esc_html( $affiliate->ID )
				);
				?>
			</td>

		</tr>

		<tr class="form-row">

			<th scope="row">
				<?php _e( 'Amount', 'affiliate-wp' ); ?>
			</th>

			<td>
				<?php echo affwp_currency_filter( affwp_format_amount( $payout->amount ) ); ?>
			</td>

		</tr>

		<tr class="form-row">

			<th scope="row">
				<?php _e( 'Generated By', 'affiliate-wp' ); ?>
			</th>

			<td>
				<?php
				if ( 0 === $payout->owner ) {
					echo _ex( '(none)', 'payout owner', 'affiliate-wp' );
				} else {
					$user = get_user_by( 'id', $payout->owner );
					// If the owner exists, use it.
					if ( $user ) {
						printf( '<a href="%1$s">%2$s</a> %3$s',
							esc_url( get_edit_user_link( $payout->owner ) ),
							esc_html( $user->data->display_name ),
							/* translators: Payout owner ID */
							sprintf( _x( '(User ID: %d)', 'payout owner ID', 'affiliate-wp' ),
								esc_html( $payout->owner )
							)
						);
					} else {
						// Otherwise the owner doesn't exist.
						_e( '(user deleted)', 'affiliate-wp' );
					}
				}
				?>
			</td>

		</tr>

		<tr class="form-row">

			<th scope="row">
				<?php _e( 'Payout Method', 'affiliate-wp' ); ?>
			</th>

			<td>
				<?php echo empty( $payout->payout_method ) ? _x( '(none)', 'payout method', 'affiliate-wp' ) : esc_html( $payout->payout_method ); ?>
			</td>

		</tr>

		<tr class="form-row">

			<th scope="row">
				<?php _e( 'Payout Account', 'affiliate-wp' ); ?>
			</th>

			<td>
				<?php echo empty( $payout->service_account ) ? _x( '(none)', 'payout service acccount', 'affiliate-wp' ) : esc_html( $payout->service_account ); ?>
			</td>

		</tr>

		<tr class="form-row">

			<th scope="row">
				<?php _e( 'Invoice Link', 'affiliate-wp' ); ?>
			</th>

			<td>
				<?php
				if ( empty( $payout->service_invoice_link) ) {
					_ex( '(none)', 'payout service invoice link', 'affiliate-wp' );
				} else {
					printf( '<a href="%1$s" target="_blank">%2$s</a>',
						esc_url( $payout->service_invoice_link ),
						esc_url( $payout->service_invoice_link )
					);
				}
				?>
			</td>

		</tr>

		<tr class="form-row">

			<th scope="row">
				<?php _e( 'Status', 'affiliate-wp' ); ?>
			</th>

			<td>
				<?php
				// Use the new payout status badge helper.
				affwp_payout_status_badge( $payout->status );
				?>
			</td>

		</tr>


		<tr class="form-row">

			<th scope="row">
				<?php _e( 'Description', 'affiliate-wp' ); ?>
			</th>

			<td>
				<?php echo empty( $payout->description ) ? _x( '(none)', 'payout description', 'affiliate-wp' ) : esc_html( $payout->description ); ?>
			</td>

		</tr>

		<tr class="form-row">

			<th scope="row">
				<?php _e( 'Payout Date', 'affiliate-wp' ); ?>
			</th>

			<td>
				<?php echo $payout->date_i18n( 'datetime' ); ?>
			</td>

		</tr>

		<?php
		/**
		 * Fires at the end of the 'View Payout' page, just inside the closing table tag.
		 *
		 * @since 1.9
		 *
		 * @param \AffWP\Affiliate\Payout $payout Payout object.
		 */
		do_action( 'affwp_edit_payout_end', $payout );
		?>

	</table>

	<?php
	$referrals = new AffWP_Referrals_Table( array(
		'query_args' => array(
			'payout_id' => $payout->ID
		),
		'display_args' => array(
			'hide_table_nav'       => false,
			'hide_bulk_options'    => true,
			'hide_pagination'      => false,
			'columns_to_hide'      => array( 'cb', 'status' ),
			'hide_column_controls' => true,
		),
	) );
	$referrals->prepare_items();
	?>
	<h2><?php _e( 'Referrals Paid', 'affiliate-wp' ); ?></h2>
	<?php
	$referrals->display();

	/**
	 * Fires at the end of the 'View Payout' page, just inside the closing div.
	 *
	 * @since 1.9
	 *
	 * @param \AffWP\Affiliate\Payout $payout Payout object.
	 */
	do_action( 'affwp_edit_payout_bottom', $payout );
	?>

</div>
