<?php

class Affiliate_WP_Lifetime_Commissions_PMP extends Affiliate_WP_Lifetime_Commissions_Base {

	/**
	 * Get things started
	 *
	 * @access  public
	 * @since   1.0
	 */
	public function init() {
		$this->context = 'pmp';
	}

	/**
	 * Retrieve the email address of a customer from the MemberOrder
	 *
	 * @access  public
	 * @since   2.0
	 * @param   int $reference The order reference ID.
	 * @return  string The customer's email address or empty string if not found.
	 */
	public function get_email( $reference = 0 ) {
		$email = '';

		// Validate reference ID.
		if ( ! $reference ) {
			return $email;
		}

		$order = new MemberOrder( $reference );

		// Validate order object.
		if ( ! $order || ! $order->id ) {
			return $email;
		}

		// First try to get email from billing info.
		if ( isset( $order->billing ) && ! empty( $order->billing->email ) ) {
			$email = $order->billing->email;
		} elseif ( ! empty( $order->user_id ) ) {
			// If no billing email, try to get from user account.
			$user = get_userdata( $order->user_id );
			if ( $user && ! empty( $user->user_email ) ) {
				$email = $user->user_email;
			}
		}

		return $email;
	}
}

if ( class_exists( 'MemberOrder' ) ) {
	new Affiliate_WP_Lifetime_Commissions_PMP();
}
