
<div class="acf-postbox-header">
    <h2 class="acf-postbox-title"><?php echo $this->title; ?></h2>
    <i tabindex="0" class="acf-icon acf-icon-help acf-js-tooltip" title="<?php esc_attr_e('Manually re-run the database migration. In some cases, the database update is incomplete or get interrupted when switching ACF Component Field plugin to new version. You can trigger the migration manully here.', 'acf-component_field'); ?>">?</i>
</div>

<div class="acf-postbox-inner">
    <div class="acf-fields">
    	<div class="acf-field">
            <div class="acf-input">
                <?php if (acf_component_field()->upgrader->isUpToDate()): ?>
                    <span style="background-color: #00a32a; padding: 3px 5px; color: white; border-radius: 3px; margin-right: 5px"><?php _e('Up to date', 'acf-component_field'); ?></span>
                <?php endif; ?>
        		<b><?php _e('Current Database Version:', 'acf-component_field'); ?></b>
        		<?php echo acf_component_field()->upgrader->getDbVersion(); ?>
        	</div>
        </div>
    </div>

    <p class="acf-submit">
    	<input type="submit" class="button button-primary" value="<?php echo esc_attr__('Re-run Migration', 'acf-component_field'); ?>" />
    </p>
</div>
