<?php

/**
 * Retreive the global plugin instance, or its module
 *
 * @since   2.0.0
 * @version 2.0.3
 * @param  string $module Optional module slug
 */
function acf_component_field($module = null) {
	global $acf_component_field;

	return $module? $acf_component_field->$module : $acf_component_field;
}

/**
 * Check whether the given parameter is a component field group
 *
 * @since   2.0.0
 * @version 2.0.3
 * @param  mix  $field_group Thing to check against
 */
function is_acf_component_field_group($field_group) {
	if ((is_int($field_group) || is_string($field_group)) && $group = acf_get_field_group($field_group)) {
		$field_group = $group;
	}

	if (is_array($field_group) && isset($field_group['is_acf_component'])) {
		return !! $field_group['is_acf_component'];
	}

	if (is_array($field_group) && isset($field_group['ID'])) {
		return !! get_post_meta($field_group['ID'], 'is_acf_component', true);
	}

	if (is_object($field_group) && isset($field_group->ID)) {
		return !! get_post_meta($field_group->ID, 'is_acf_component', true);
	}

	return false;
}
