<?php

namespace ACP\Sorting\FormatValue;

use ACP\Sorting\FormatValue;

class FileSize implements FormatValue
{

    public function format_value($file)
    {
        if ($this->is_relative_path($file)) {
            $uploads = wp_get_upload_dir();

            if (false === $uploads['error']) {
                $file = sprintf("%s/%s", $uploads['basedir'], $file);
            }
        }

        return $file && is_string($file) && is_file($file)
            ? filesize($file)
            : null;
    }

    private function is_relative_path($file): bool
    {
        return $file && is_string($file) && 0 !== strpos($file, '/') && ! preg_match('|^.:\\\|', $file);
    }

}
