<?php

namespace ACP\Query\Type;

use ACP\Query;
use ACP\Query\Bindings\QueryArguments;
use WP_Tax_Query;
use WP_User_Query;

class User extends Query
{

    public function register(): void
    {
        add_filter('users_list_table_query_args', [$this, 'mark_as_table_query']);
        add_action('pre_get_users', [$this, 'callback_meta_query'], 1);
        add_action('pre_get_users', [$this, 'callback_tax_query'], 1);
        add_action('pre_get_users', [$this, 'callback_query_arguments'], 1);
        add_action('pre_user_query', [$this, 'callback_tax_query_sql'], 1);
        add_action('pre_user_query', [$this, 'callback_where'], 1);
        add_action('pre_user_query', [$this, 'callback_join'], 1);
        add_action('pre_user_query', [$this, 'callback_order_by'], 1);
        add_action('pre_user_query', [$this, 'callback_group_by'], 1);
    }

    /**
     * Marks the main list table query as such
     */
    public function mark_as_table_query($args): array
    {
        $args['is_list_table_query'] = 1;

        return $args;
    }

    public function callback_tax_query_sql(WP_User_Query $query): void
    {
        global $wpdb;

        $tax_query = $query->query_vars['tax_query'] ?? null;

        if ( ! $tax_query) {
            return;
        }

        $tax = new WP_Tax_Query($tax_query);
        $sql = $tax->get_sql($wpdb->users, 'ID');

        $query->query_from .= $sql['join'];
        $query->query_where .= $sql['where'];
    }

    public function callback_query_arguments(WP_User_Query $query): void
    {
        if ( ! $this->is_table_query($query)) {
            return;
        }

        foreach ($this->bindings as $binding) {
            if ($binding instanceof QueryArguments) {
                foreach ($binding->get_query_arguments() as $query_var => $value) {
                    $query->query_vars[$query_var] = $value;
                }
            }
        }
    }

    public function callback_tax_query(WP_User_Query $query): void
    {
        if ( ! $this->is_table_query($query)) {
            return;
        }

        $tax_query_parts = [];

        foreach ($this->bindings as $binding) {
            if ($binding instanceof Query\Bindings\User && $binding->get_tax_query()) {
                $tax_query_parts[] = $binding->get_tax_query();
            }
        }

        $tax_query_parts = array_filter($tax_query_parts);

        if (empty($tax_query_parts)) {
            return;
        }

        $existing = $query->get('tax_query') ?: [];

        $query->query_vars['tax_query'] = array_merge(
            ['relation' => 'AND'],
            $existing,
            $tax_query_parts
        );
    }

    public function callback_meta_query(WP_User_Query $query): void
    {
        if ( ! $this->is_table_query($query)) {
            return;
        }

        $meta_query = $this->get_meta_query();

        if ( ! $meta_query) {
            return;
        }

        if (isset($query->query_vars['meta_query']) && ! empty($query->query_vars['meta_query'])) {
            $meta_query[] = $query->query_vars['meta_query'];
        }

        $query->query_vars['meta_query'] = $meta_query;
    }

    public function callback_where(WP_User_Query $query): void
    {
        if ( ! $this->is_table_query($query)) {
            return;
        }

        foreach ($this->bindings as $binding) {
            if ($binding->get_where()) {
                $query->query_where .= ' AND ' . $binding->get_where();
            }
        }
    }

    public function callback_join(WP_User_Query $query): void
    {
        if ( ! $this->is_table_query($query)) {
            return;
        }

        foreach ($this->bindings as $binding) {
            if ($binding->get_join()) {
                $query->query_from .= "\n" . $binding->get_join();
            }
        }
    }

    public function callback_order_by(WP_User_Query $query): void
    {
        if ( ! $this->is_table_query($query)) {
            return;
        }

        foreach ($this->bindings as $binding) {
            if ($binding->get_order_by()) {
                $query->query_orderby = "ORDER BY " . $binding->get_order_by();
            }
        }
    }

    public function callback_group_by(WP_User_Query $query): void
    {
        if ( ! $this->is_table_query($query)) {
            return;
        }

        foreach ($this->bindings as $binding) {
            if ($binding->get_group_by() && ! str_contains(strtoupper($query->query_orderby), "GROUP BY ")) {
                $query->query_orderby = "GROUP BY " . $binding->get_group_by() . "\n" . $query->query_orderby;
            }
        }
    }

    private function is_table_query(WP_User_Query $query): bool
    {
        return isset($query->query_vars['is_list_table_query']) && 1 === $query->query_vars['is_list_table_query'];
    }

}