<?php

declare(strict_types=1);

namespace AC\Formatter\User;

use AC\Formatter;
use AC\Type\Value;

class Meta implements Formatter
{

    private string $meta_key;

    public function __construct(string $meta_key)
    {
        $this->meta_key = $meta_key;
    }

    public function format(Value $value): Value
    {
        return $value->with_value(
            get_user_meta((int)$value->get_id(), $this->meta_key, true)
        );
    }

}