<?php

declare(strict_types=1);

namespace AC\Formatter;

use AC\Formatter;
use AC\Type\Value;

class Suffix implements Formatter
{

    private string $suffix;

    public function __construct(string $suffix)
    {
        $this->suffix = $suffix;
    }

    public function format(Value $value): Value
    {
        return $value->get_value()
            ? $value->with_value($value->get_value() . $this->suffix)
            : $value;
    }

}