<?php

declare(strict_types=1);

namespace AC\Formatter\Media;

use AC\Exception\ValueNotFoundException;
use AC\Formatter;
use AC\Helper;
use AC\Type\Value;

class Dimensions implements Formatter
{

    public function format(Value $value): Value
    {
        $meta = get_post_meta($value->get_id(), '_wp_attachment_metadata', true);

        if (empty($meta['width']) || empty($meta['height'])) {
            throw new ValueNotFoundException();
        }

        $label = $meta['width'] . '&nbsp;&times;&nbsp;' . $meta['height'];
        $tooltip = sprintf(__('Width : %s px', 'codepress-admin-columns'), $meta['width']) . "<br/>\n" . sprintf(
                __('Height : %s px', 'codepress-admin-columns'),
                $meta['height']
            );

        return $value->with_value(
            Helper\Html::create()->tooltip($label, $tooltip)
        );
    }

}