<?php

declare(strict_types=1);

namespace AC\Formatter\Comment;

use AC\Formatter;
use AC\Helper;
use AC\Type\Value;

class CommentLink implements Formatter
{

    private string $link_to;

    public function __construct(string $link_to)
    {
        $this->link_to = $link_to;
    }

    public function format(Value $value): Value
    {
        $link = false;

        switch ($this->link_to) {
            case 'view_comment' :
                $link = get_comment_link($value->get_id());

                break;
            case 'edit_comment' :
                $comment = get_comment($value->get_id());

                $link = $comment
                    ? get_edit_comment_link($comment)
                    : false;

                break;
        }

        return $link
            ? $value->with_value(Helper\Html::create()->link($link, $value->get_value()))
            : $value;
    }

}