<?php

declare(strict_types=1);

namespace AC\Formatter;

use AC\Formatter;
use AC\Helper;
use AC\Type\Value;

class CodeBlock implements Formatter
{

    public function format(Value $value): Value
    {
        return $value->with_value(
            Helper\Html::create()->codearea((string)$value)
        );
    }

}