<?php

declare(strict_types=1);

namespace AC\ColumnFactory\Media;

use AC\Column\BaseColumnFactory;
use AC\Formatter\Media\PreviewViewLink;
use AC\FormatterCollection;
use AC\Setting\Config;
use AC\Value\Extended\MediaPreview;

class PreviewFactory extends BaseColumnFactory
{

    public function get_column_type(): string
    {
        return 'column-preview';
    }

    public function get_label(): string
    {
        return __('Preview', 'codepress-admin-columns');
    }

    protected function get_formatters(Config $config): FormatterCollection
    {
        $formatters = parent::get_formatters($config);

        $formatters->add(new PreviewViewLink(new MediaPreview()));

        return $formatters;
    }

}