<?php

declare(strict_types=1);

namespace AC\ColumnFactory\Media;

use AC\Column\BaseColumnFactory;
use AC\Formatter\Media\NestedAttachmentMetaData;
use AC\FormatterCollection;
use AC\Setting\ComponentCollection;
use AC\Setting\ComponentFactory\Media\FileMetaVideo;
use AC\Setting\Config;
use AC\Setting\DefaultSettingsBuilder;

class FileMetaVideoFactory extends BaseColumnFactory
{

    private FileMetaVideo $file_meta_video;

    public function __construct(
        DefaultSettingsBuilder $default_settings_builder,
        FileMetaVideo $file_meta_video
    ) {
        parent::__construct($default_settings_builder);

        $this->file_meta_video = $file_meta_video;
    }

    protected function get_settings(Config $config): ComponentCollection
    {
        return new ComponentCollection([
            $this->file_meta_video->create($config),
        ]);
    }

    public function get_column_type(): string
    {
        return 'column-meta_video';
    }

    public function get_label(): string
    {
        return __('Video Meta', 'codepress-admin-columns');
    }

    protected function get_group(): ?string
    {
        return 'media-video';
    }

    protected function get_formatters(Config $config): FormatterCollection
    {
        $formatters = parent::get_formatters($config);
        $meta_keys = array_filter(array_map('trim', explode('.', $config->get('media_meta_key', ''))));

        $formatters->prepend(new NestedAttachmentMetaData($meta_keys));

        return $formatters;
    }

}