<?php

namespace AC\Admin;

use AC;
use AC\AdminColumns;
use AC\Registerable;

class Admin implements Registerable
{

    public const NAME = 'codepress-admin-columns';

    private RequestHandlerInterface $request_handler;

    private AC\Asset\Location $location;

    private AdminScripts $scripts;

    public function __construct(RequestHandlerInterface $request_handler, AdminColumns $plugin, AdminScripts $scripts)
    {
        $this->request_handler = $request_handler;
        $this->location = $plugin->get_location();
        $this->scripts = $scripts;
    }

    public function register(): void
    {
        add_action('admin_menu', [$this, 'init']);
    }

    private function get_menu_page_factory(): MenuPageFactory
    {
        return apply_filters(
            'ac/menu_page_factory',
            new MenuPageFactory\SubMenu()
        );
    }

    public function init(): void
    {
        $hook = $this->get_menu_page_factory()->create([
            'parent' => 'options-general.php',
            'icon'   => $this->location->with_suffix('assets/images/page-menu-icon.svg')->get_url(),
        ]);

        $loader = new AdminLoader($hook, $this->request_handler, $this->scripts);
        $loader->register();
    }

}