<?php

declare(strict_types=1);

namespace ACA\WC\Value\Formatter\Order;

use AC\Exception\ValueNotFoundException;
use AC\Type\Value;
use WC_Order;

class ShippingMethodIds extends OrderMethod
{

    protected function get_order_value(WC_Order $order, Value $value): Value
    {
        $values = [];
        foreach ($order->get_shipping_methods() as $method) {
            $values[] = $method->get_method_id();
        }

        if (empty($values)) {
            throw ValueNotFoundException::from_id($value->get_id());
        }

        return $value->with_value(
            implode(', ', $values)
        );
    }

}