<?php

declare(strict_types=1);

namespace ACA\WC\Value\Formatter\Order;

use AC\Formatter;
use AC\Helper;
use AC\Type\Value;

class IsCustomerIcon implements Formatter
{

    public function format(Value $value)
    {
        $icon = $value->get_value()
            ? Helper\Icon::create()->yes(get_userdata($value->get_id())->display_name)
            : Helper\Icon::create()->no(__('Guest', 'woocommerce'));

        return $value->with_value($icon);
    }

}