<?php

declare(strict_types=1);

namespace ACA\WC\Search\Order\Notes;

use ACP\Query\Bindings;
use ACP\Search\Comparison;
use ACP\Search\Helper\Sql\ComparisonFactory;
use ACP\Search\Operators;
use ACP\Search\Value;

class SystemNotes extends Comparison
{

    public function __construct()
    {
        $operators = new Operators(
            [
                Operators::CONTAINS,
                Operators::NOT_CONTAINS,
                Operators::BEGINS_WITH,
                Operators::ENDS_WITH,
            ], false
        );

        parent::__construct($operators);
    }

    protected function create_query_bindings(string $operator, Value $value): Bindings
    {
        global $wpdb;

        $bindings = new Bindings();

        $alias = $bindings->get_unique_alias('nosy');

        // System notes have `WooCommerce` as the author
        $join = $wpdb->prepare(
            "INNER JOIN $wpdb->comments AS $alias ON ( {$wpdb->prefix}wc_orders.id = $alias.comment_post_ID AND $alias.comment_type = 'order_note' AND $alias.comment_author = %s )",
            __('WooCommerce', 'woocommerce')
        );

        $bindings->join($join)
                 ->group_by("{$wpdb->prefix}wc_orders.id");

        $comparison = ComparisonFactory::create(
            "$alias.comment_content",
            $operator,
            $value
        );

        $where[] = $comparison();

        $bindings->where(implode(' AND ', $where));

        return $bindings;
    }

}