<?php

declare(strict_types=1);

namespace ACA\WC\Editing\ProductVariation;

use ACP;
use ACP\Editing\View;

class Weight implements ACP\Editing\Service
{

    public function get_value(int $id)
    {
        $product = wc_get_product($id);

        return $product
            ? $product->get_weight()
            : false;
    }

    public function get_view(string $context): ?View
    {
        $view = new ACP\Editing\View\Number();
        $view->set_step('any');
        $view->set_min(0);

        return $view;
    }

    public function update(int $id, $data): void
    {
        $product = wc_get_product($id);
        $product->set_weight($data);
        $product->save();
    }

}