<?php

declare(strict_types=1);

namespace ACA\WC\ColumnFactory\Order;

use AC\FormatterCollection;
use AC\Setting\Config;
use ACA\WC\ColumnFactory\WooCommerceGroupTrait;
use ACA\WC\Editing\Order\PaymentMethod;
use ACA\WC\Search;
use ACA\WC\Sorting;
use ACA\WC\Value\Formatter;
use ACP;

class PaymentMethodFactory extends ACP\Column\AdvancedColumnFactory
{

    use ACP\ConditionalFormat\ConditionalFormatTrait;
    use WooCommerceGroupTrait;

    public function get_label(): string
    {
        return __('Payment Method', 'codepress-admin-columns');
    }

    public function get_column_type(): string
    {
        return 'column-order_payment_method';
    }

    protected function get_formatters(Config $config): FormatterCollection
    {
        return parent::get_formatters($config)->prepend(new Formatter\Order\PaymentMethod());
    }

    protected function get_search(Config $config): ?ACP\Search\Comparison
    {
        return new Search\Order\PaymentMethod();
    }

    protected function get_sorting(Config $config): ?ACP\Sorting\Model\QueryBindings
    {
        return new Sorting\Order\OrderData('payment_method_title');
    }

    protected function get_editing(Config $config): ?ACP\Editing\Service
    {
        return new PaymentMethod();
    }

}