<?php

declare(strict_types=1);

namespace ACA\EC\ColumnFactories;

use AC;
use AC\ColumnFactoryDefinitionCollection;
use AC\TableScreen;
use ACA\EC\API;
use ACA\EC\ColumnFactory;

class EventFactory extends AC\ColumnFactories\BaseFactory
{

    protected function get_factories(TableScreen $table_screen): ColumnFactoryDefinitionCollection
    {
        $collection = new ColumnFactoryDefinitionCollection();

        if ( ! $table_screen instanceof AC\TableScreen\Post
             || ! $table_screen->get_post_type()->equals('tribe_events')) {
            return $collection;
        }

        $factories = [
            ColumnFactory\Event\AllDayEventFactory::class,
            ColumnFactory\Event\CostsFactory::class,
            ColumnFactory\Event\DisplayDateFactory::class,
            ColumnFactory\Event\DurationFactory::class,
            ColumnFactory\Event\FeaturedFactory::class,
            ColumnFactory\Event\HideFromUpcomingFactory::class,
            ColumnFactory\Event\OrganizerFactory::class,
            ColumnFactory\Event\StickyFactory::class,
            ColumnFactory\Event\VenueFactory::class,
            ColumnFactory\Event\WebsiteFactory::class,
            ColumnFactory\Event\EventStatusFactory::class,
            ColumnFactory\Event\EventStatusReasonFactory::class,

        ];

        if (API::is_pro()) {
            $factories[] = ColumnFactory\Event\VirtualEventTypeFactory::class;
            $factories[] = ColumnFactory\Event\EventSerieFactory::class;
        }

        foreach ($factories as $factory) {
            $collection->add(new AC\Type\ColumnFactoryDefinition($factory));
        }

        return $collection;
    }

}