<?php

declare(strict_types=1);

namespace ACA\ACF\Field\Type;

use ACA\ACF\Field;

class Taxonomy extends Field implements Field\Multiple, Field\TermRelation
{

    public function uses_native_term_relation(): bool
    {
        return (1 === $this->settings['load_terms'] && 1 === $this->settings['save_terms']);
    }

    public function is_multiple(): bool
    {
        return in_array($this->settings['field_type'], ['checkbox', 'multi_select'], true);
    }

    public function get_taxonomy(): string
    {
        return (string)$this->settings['taxonomy'];
    }

}