<?php
/**
 * Admin Button Template for Onetap plugin.
 *
 * This template is responsible for rendering the button section
 * of the plugin's admin pages, including logo, documentation links,
 * support links, and navigation menu.
 *
 * @package    Accessibility_Plugin_Onetap_Pro
 * @subpackage Accessibility_Plugin_Onetap_Pro/admin/partials
 */

$apop_settings = get_option( 'apop_settings' );
if ( ! is_array( $apop_settings ) ) {
	$apop_settings = array();
}

$apop_toggle_classes = array_filter(
	array(
		! empty( $apop_settings['border'] ) ? $apop_settings['border'] : '',
		isset( $apop_settings['toggle-device-position-desktop'] ) && 'on' === $apop_settings['toggle-device-position-desktop'] ? 'hide-on-desktop' : '',
		isset( $apop_settings['toggle-device-position-tablet'] ) && 'on' === $apop_settings['toggle-device-position-tablet'] ? 'hide-on-tablet' : '',
		isset( $apop_settings['toggle-device-position-mobile'] ) && 'on' === $apop_settings['toggle-device-position-mobile'] ? 'hide-on-mobile' : '',
	)
);
?>

<button type="button" aria-label="Toggle Accessibility Toolbar" class="onetap-toggle <?php echo esc_attr( implode( ' ', $apop_toggle_classes ) ); ?>">				
	<?php
	// Define SVG paths for each icon type.
	$apop_icon_paths = array(
		'design1' => 'assets/images/admin/Original_Logo_Icon.svg',
		'design2' => 'assets/images/admin/Hand_Icon.svg',
		'design3' => 'assets/images/admin/Accessibility-Man-Icon.svg',
		'design4' => 'assets/images/admin/Settings-Filter-Icon.svg',
		'design5' => 'assets/images/admin/Switcher-Icon.svg',
		'design6' => 'assets/images/admin/Eye-Show-Icon.svg',
	);

	// Check if the selected icon exists in the array.
	if ( isset( $apop_settings['icons'], $apop_icon_paths[ $apop_settings['icons'] ] ) ) {
		$apop_icons = array(
			'design1' => 'Original_Logo_Icon.svg',
			'design2' => 'Hand_Icon.svg',
			'design3' => 'Accessibility-Man-Icon.svg',
			'design4' => 'Settings-Filter-Icon.svg',
			'design5' => 'Switcher-Icon.svg',
			'design6' => 'Eye-Show-Icon.svg',
		);
		foreach ( $apop_icons as $apop_icon_value => $apop_icon_image ) {
			if ( $apop_icon_value === $apop_settings['icons'] ) {
				$apop_class_size   = isset( $apop_settings['size'] ) ? $apop_settings['size'] : '';
				$apop_class_border = isset( $apop_settings['border'] ) ? $apop_settings['border'] : '';
				echo '<img class="' . esc_attr( $apop_class_size ) . ' ' . esc_attr( $apop_class_border ) . '" src="' . esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/admin/' . $apop_icon_image ) . '" alt="toggle icon" />';
			}
		}
	} else {
		echo '<img class="design-size2 design-border2" src="' . esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/admin/Original_Logo_Icon.svg' ) . '" alt="toggle icon" />';
	}
	?>
</button>