<?php
/**
 * Content template for submenu page.
 *
 * @package    Accessibility_Plugin_Onetap_Pro
 * @since      1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<div class="wrap">
	<?php apop_load_template( 'admin/partials/header.php' ); ?>
	<div class="box-current-language" style="display: none;">
		<a href="<?php echo esc_url( admin_url() . 'admin.php?page=apop-settings' ); ?>" class="current-language">
			<ul style="display: none;">
				<li role="listitem" data-language="en">
					<button type="button">
						<?php esc_html_e( 'English', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/english.png' ); ?>" alt="flag">
					</button>			
				</li>
				<li role="listitem" data-language="de">
					<button type="button">
						<?php esc_html_e( 'Deutsch', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/german.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="es">
					<button type="button">
						<?php esc_html_e( 'Español', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/spanish.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="fr">
					<button type="button">
						<?php esc_html_e( 'Français', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/french.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="it">
					<button type="button">
						<?php esc_html_e( 'Italiano', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/italia.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="pl">
					<button type="button">
						<?php esc_html_e( 'Polski', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/poland.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="se">
					<button type="button">
						<?php esc_html_e( 'Svenska', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/swedish.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="fi">
					<button type="button">
						<?php esc_html_e( 'Suomi', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/finnland.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="pt">
					<button type="button">
						<?php esc_html_e( 'Português', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/portugal.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="ro">
					<button type="button">
						<?php esc_html_e( 'Română', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/rumania.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="si">
					<button type="button">
						<?php esc_html_e( 'Slovenščina', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/slowakia.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="sk">
					<button type="button">
						<?php esc_html_e( 'Slovenčina', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/slowenien.png' ); ?>" alt="flag">	
					</button>
				</li>					
				<li role="listitem" data-language="nl">
					<button type="button">
						<?php esc_html_e( 'Nederlands', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/netherland.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="dk">
					<button type="button">
						<?php esc_html_e( 'Dansk', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/danish.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="gr">
					<button type="button">
						<?php esc_html_e( 'Ελληνικά', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/greece.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="cz">
					<button type="button">
						<?php esc_html_e( 'Čeština', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/czech.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="hu">
					<button type="button">
						<?php esc_html_e( 'Magyar', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/hungarian.png' ); ?>" alt="flag">	
					</button>
				</li>									
				<li role="listitem" data-language="lt">
					<button type="button">
						<?php esc_html_e( 'Lietuvių', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/lithuanian.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="lv">
					<button type="button">
						<?php esc_html_e( 'Latviešu', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/latvian.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="ee">
					<button type="button">
						<?php esc_html_e( 'Eesti', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/estonian.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="hr">
					<button type="button">
						<?php esc_html_e( 'Hrvatski', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/croatia.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="ie">
					<button type="button">
						<?php esc_html_e( 'Gaeilge', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/ireland.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="bg">
					<button type="button">
						<?php esc_html_e( 'Български', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/bulgarian.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="no">
					<button type="button">
						<?php esc_html_e( 'Norsk', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/norwegan.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="tr">
					<button type="button">
						<?php esc_html_e( 'Türkçe', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/turkish.png' ); ?>" alt="flag">	
					</button>
				</li>
				<li role="listitem" data-language="id">
					<button type="button">
						<?php esc_html_e( 'Bahasa Indonesia', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/indonesian.png' ); ?>" alt="flag">	
					</button>
				</li>		
				<li role="listitem" data-language="pt-br">
					<button type="button">
						<?php esc_html_e( 'Português (Brasil)', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/brasilian.png' ); ?>" alt="flag">	
					</button>
				</li>	
				<li role="listitem" data-language="ja">
					<button type="button">
						<?php esc_html_e( '日本語', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/japanese.png' ); ?>" alt="flag">	
					</button>
				</li>	
				<li role="listitem" data-language="ko">
					<button type="button">
						<?php esc_html_e( '한국어', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/korean.png' ); ?>" alt="flag">	
					</button>
				</li>	
				<li role="listitem" data-language="zh">
					<button type="button">
						<?php esc_html_e( '简体中文', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/chinese-simplified.png' ); ?>" alt="flag">	
					</button>
				</li>	
				<li role="listitem" data-language="ar">
					<button type="button">
						<?php esc_html_e( 'العربية', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/arabic.png' ); ?>" alt="flag">	
					</button>
				</li>	
				<li role="listitem" data-language="ru">
					<button type="button">
						<?php esc_html_e( 'Русский', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/russian.png' ); ?>" alt="flag">	
					</button>
				</li>	
				<li role="listitem" data-language="hi">
					<button type="button">
						<?php esc_html_e( 'हिन्दी', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/hindi.png' ); ?>" alt="flag">	
					</button>
				</li>	
				<li role="listitem" data-language="uk">
					<button type="button">
						<?php esc_html_e( 'Українська', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/ukrainian.png' ); ?>" alt="flag">	
					</button>
				</li>	
				<li role="listitem" data-language="sr">
					<button type="button">
						<?php esc_html_e( 'Srpski', 'accessibility-plugin-onetap-pro' ); ?>
						<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/serbian.png' ); ?>" alt="flag">	
					</button>
				</li>	
			</ul>
			<div class="image">
				<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/english.png' ); ?>" alt="flag" class="active">
			</div>
			<span class="text">
				<?php esc_html_e( 'Currently editing', 'accessibility-plugin-onetap-pro' ); ?>
				<strong><?php esc_html_e( 'English', 'accessibility-plugin-onetap-pro' ); ?></strong> 
				<?php esc_html_e( 'labels. Change the language to edit others.', 'accessibility-plugin-onetap-pro' ); ?>
			</span>
		</a>
	</div>
	<?php $this->settings_api->show_forms(); ?>
	<?php apop_load_template( 'admin/partials/footer.php' ); ?>
</div>