<?php
/**
 * Content template for submenu page.
 *
 * @package    Accessibility_Plugin_Onetap_Pro
 * @since      1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<div class="wrap">
	<!-- Header -->
	<header class="top">
		<div class="mycontainer">
			<div class="myrow myrow1">
				<div class="left">
					<img src="<?php echo esc_url( ACCESSIBILITY_PLUGIN_ONETAP_PRO_PLUGINS_URL . 'assets/images/logo.png' ); ?>" alt="<?php echo esc_attr__( 'logo', 'accessibility-plugin-onetap-pro' ); ?>">
				</div>
				<div class="right">
					<a target="_blank" href="<?php echo esc_url( 'https://wponetap.com/support/' ); ?>" class="button">
						<?php esc_html_e( 'Support', 'accessibility-plugin-onetap-pro' ); ?>
					</a>
				</div>
			</div>
			<div class="myrow myrow2">
				<h2><?php esc_html_e( 'Accessibility Settings', 'accessibility-plugin-onetap-pro' ); ?></h2>
				<p class="desc"><?php esc_html_e( 'Customize your browsing experience by enabling or disabling various accessibility modules.', 'accessibility-plugin-onetap-pro' ); ?>
					<br>
					<?php esc_html_e( 'For the best results, we recommend keeping all features turned on to maximize ease of use and inclusivity.', 'accessibility-plugin-onetap-pro' ); ?>
				</p>
			</div>
		</div>
	</header>
	<section class="box-button-navigation">
		<div class="separator"></div>
		<ul>
			<li>
				<a class="button" href="#anchorAccessibilityProfiles">
					<?php esc_html_e( 'Accessibility Profiles', 'accessibility-plugin-onetap-pro' ); ?>
				</a>
			</li>
			<li>
				<a class="button" href="#anchorContentModules">
					<?php esc_html_e( 'Content Modules', 'accessibility-plugin-onetap-pro' ); ?>
				</a>
			</li>
			<li>
				<a class="button" href="#anchorModulesColors">
					<?php esc_html_e( 'Colors', 'accessibility-plugin-onetap-pro' ); ?>
				</a>
			</li>
			<li>
				<a class="button" href="#anchorOrientation">
					<?php esc_html_e( 'Orientation', 'accessibility-plugin-onetap-pro' ); ?>
				</a>
			</li>
		</ul>
	</section>
	<?php $this->settings_api->show_forms(); ?>
</div>